/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet;

import io.takamaka.wallet.beans.TkmCypherBean;
import io.takamaka.wallet.exceptions.KeyDecodeException;
import io.takamaka.wallet.utils.TkmSignUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.UrlBase64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkmCypherProviderBCED25519 {
    private static final Logger log = LoggerFactory.getLogger(TkmCypherProviderBCED25519.class);

    public static TkmCypherBean sign(AsymmetricCipherKeyPair keyPair, String message) {
        TkmCypherBean tcb = new TkmCypherBean();
        tcb.setValid(false);
        try {
            byte[] byteMessage = Strings.toByteArray((String)message);
            Ed25519Signer signer = new Ed25519Signer();
            signer.reset();
            signer.init(true, (CipherParameters)((Ed25519PrivateKeyParameters)keyPair.getPrivate()));
            signer.update(byteMessage, 0, byteMessage.length);
            byte[] generatedSignature = signer.generateSignature();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.encode((byte[])generatedSignature, (OutputStream)baos);
            tcb.setSignature(baos.toString());
            tcb.setValid(true);
            baos.close();
        }
        catch (IOException ex) {
            tcb.setEx(ex);
            tcb.setValid(false);
            log.error("Error signing message.", (Throwable)ex);
        }
        return tcb;
    }

    public static TkmCypherBean verify(AsymmetricCipherKeyPair keyPair, String signature, String message) {
        TkmCypherBean tcb = new TkmCypherBean();
        tcb.setValid(false);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.decode((String)signature, (OutputStream)baos);
            byte[] signatureByteArray = baos.toByteArray();
            byte[] messageByteArray = Strings.toByteArray((String)message);
            Ed25519Signer verifier = new Ed25519Signer();
            verifier.reset();
            Ed25519PublicKeyParameters edPublicKey = (Ed25519PublicKeyParameters)keyPair.getPublic();
            verifier.init(false, (CipherParameters)edPublicKey);
            verifier.update(messageByteArray, 0, messageByteArray.length);
            tcb.setValid(verifier.verifySignature(signatureByteArray));
            baos.close();
        }
        catch (IOException ex) {
            tcb.setEx(ex);
            tcb.setValid(false);
            log.error("Error verifying signature.", (Throwable)ex);
        }
        return tcb;
    }

    public static TkmCypherBean verify(String publicKey, String signature, String message) {
        try {
            return TkmCypherProviderBCED25519.verify(TkmSignUtils.stringPublicKeyToKeyPairBCEd25519(publicKey), signature, message);
        }
        catch (KeyDecodeException ex) {
            TkmCypherBean tcb = new TkmCypherBean();
            tcb.setEx(ex);
            tcb.setValid(false);
            log.error("Error verifying signature.", (Throwable)ex);
            return tcb;
        }
    }
}

