/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.wallet;

import io.takamaka.wallet.InstanceWalletKeystoreInterface;
import io.takamaka.wallet.beans.KeyBean;
import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.exceptions.InvalidWalletIndexException;
import io.takamaka.wallet.exceptions.PublicKeySerializzationException;
import io.takamaka.wallet.exceptions.UnlockWalletException;
import io.takamaka.wallet.exceptions.WalletBurnedException;
import io.takamaka.wallet.exceptions.WalletEmptySeedException;
import io.takamaka.wallet.utils.DefaultInitParameters;
import io.takamaka.wallet.utils.FileHelper;
import io.takamaka.wallet.utils.KeyContexts;
import io.takamaka.wallet.utils.SeedGenerator;
import io.takamaka.wallet.utils.SeededRandom;
import io.takamaka.wallet.utils.TkmTextUtils;
import io.takamaka.wallet.utils.WalletHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.util.encoders.UrlBase64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceWalletKeyStoreBCED25519
implements InstanceWalletKeystoreInterface {
    private static final Logger log = LoggerFactory.getLogger(InstanceWalletKeyStoreBCED25519.class);
    private Map<Integer, AsymmetricCipherKeyPair> signKeys;
    private Map<Integer, String> hexPublicKeys;
    private Map<Integer, byte[]> bytePublicKeys;
    private String seed;
    private String currentWalletName;
    private boolean isInitialized;
    private static final KeyContexts.WalletCypher walletCypher = KeyContexts.WalletCypher.Ed25519BC;
    private final Object constructorLock = new Object();
    private final Object getKeyPairAtIndexLock = new Object();
    private final Object getPublicKeyAtIndexHexLock = new Object();
    private final Object getPublicKeyAtIndexByteLock = new Object();

    @Override
    public KeyContexts.WalletCypher getWalletCypher() {
        return walletCypher;
    }

    @Override
    public String getCurrentWalletID() {
        return this.currentWalletName + walletCypher.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceWalletKeyStoreBCED25519(String walletName) throws UnlockWalletException {
        Object object = this.constructorLock;
        synchronized (object) {
            if (!this.isInitialized) {
                try {
                    this.currentWalletName = walletName + DefaultInitParameters.WALLET_EXTENSION;
                    this.signKeys = Collections.synchronizedMap(new HashMap());
                    this.hexPublicKeys = Collections.synchronizedMap(new HashMap());
                    this.bytePublicKeys = Collections.synchronizedMap(new HashMap());
                    this.initWallet("Password");
                }
                catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | IOException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
                    log.error("instance error name", (Throwable)ex);
                    throw new UnlockWalletException(ex);
                }
                this.isInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceWalletKeyStoreBCED25519(String walletName, String password) throws UnlockWalletException {
        Object object = this.constructorLock;
        synchronized (object) {
            if (!this.isInitialized) {
                try {
                    this.currentWalletName = walletName + DefaultInitParameters.WALLET_EXTENSION;
                    this.signKeys = Collections.synchronizedMap(new HashMap());
                    this.hexPublicKeys = Collections.synchronizedMap(new HashMap());
                    this.bytePublicKeys = Collections.synchronizedMap(new HashMap());
                    this.initWallet(password);
                }
                catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | IOException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
                    log.error("instance error name password", (Throwable)ex);
                    throw new UnlockWalletException("instance error name password", ex);
                }
                this.isInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceWalletKeyStoreBCED25519(String walletName, int nCharForSeed) throws UnlockWalletException, WalletEmptySeedException, WalletBurnedException {
        Object object = this.constructorLock;
        synchronized (object) {
            if (!this.isInitialized) {
                try {
                    this.currentWalletName = walletName + DefaultInitParameters.WALLET_EXTENSION;
                    this.signKeys = Collections.synchronizedMap(new HashMap());
                    this.hexPublicKeys = Collections.synchronizedMap(new HashMap());
                    this.bytePublicKeys = Collections.synchronizedMap(new HashMap());
                    this.initWallet(nCharForSeed);
                }
                catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException | IOException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
                    log.error("instance error seed", (Throwable)ex);
                    throw new UnlockWalletException("instance error seed", ex);
                }
                this.isInitialized = true;
            }
        }
    }

    private void initWallet(String password) throws IOException, NoSuchAlgorithmException, HashEncodeException, InvalidKeySpecException, HashAlgorithmNotFoundException, HashProviderNotFoundException, UnlockWalletException {
        Path currentWalletPath;
        if (!FileHelper.walletDirExists()) {
            FileHelper.createDir(FileHelper.getEphemeralWalletDirectoryPath());
        }
        if (!FileHelper.fileExists(Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), this.currentWalletName))) {
            List<String> words = SeedGenerator.generateWords();
            this.seed = SeedGenerator.generateSeedPWH(words);
            Object concat = words.get(0);
            for (int i = 1; i < words.size(); ++i) {
                concat = (String)concat + " " + words.get(i);
            }
            KeyBean kb = new KeyBean("POWSEED", KeyContexts.WalletCypher.Ed25519BC, this.seed, (String)concat);
            try {
                WalletHelper.writeKeyFile(FileHelper.getDefaultWalletDirectoryPath(), this.currentWalletName, kb, password);
            }
            catch (InvalidKeyException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
                log.error("instance error password", (Throwable)ex);
                throw new UnlockWalletException("instance error password", ex);
            }
        }
        if (FileHelper.fileExists(currentWalletPath = Paths.get(FileHelper.getDefaultWalletDirectoryPath().toString(), this.currentWalletName))) {
            try {
                this.seed = WalletHelper.readKeyFile(currentWalletPath, password).getSeed();
            }
            catch (FileNotFoundException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchProviderException | NoSuchPaddingException ex) {
                log.error("initWallet unreadable file?", (Throwable)ex);
                throw new IOException("initWallet unreadable file?", ex);
            }
        }
    }

    private void initWallet(int nCharSeed) throws IOException, NoSuchAlgorithmException, HashEncodeException, InvalidKeySpecException, HashAlgorithmNotFoundException, HashProviderNotFoundException, UnlockWalletException, WalletBurnedException, WalletEmptySeedException {
        Path currentWalletPath;
        if (!FileHelper.walletDirExists()) {
            FileHelper.createDir(FileHelper.getEphemeralWalletDirectoryPath());
        }
        if (!FileHelper.fileExists(Paths.get(FileHelper.getEphemeralWalletDirectoryPath().toString(), this.currentWalletName))) {
            this.seed = RandomStringUtils.randomAlphabetic((int)nCharSeed);
            FileHelper.writeStringToFile(FileHelper.getEphemeralWalletDirectoryPath(), this.currentWalletName, this.seed, false);
        }
        if (FileHelper.fileExists(currentWalletPath = Paths.get(FileHelper.getEphemeralWalletDirectoryPath().toString(), this.currentWalletName))) {
            try {
                this.seed = FileHelper.readStringFromFile(Paths.get(FileHelper.getEphemeralWalletDirectoryPath().toString(), this.currentWalletName));
                if ("burned".equals(this.seed)) {
                    throw new WalletBurnedException("WALLET IS BURNED");
                }
                if (TkmTextUtils.isNullOrBlank(this.seed)) {
                    throw new WalletEmptySeedException("WALLET SEED IS EMPTY");
                }
            }
            catch (FileNotFoundException ex) {
                log.error("instance error nseed", (Throwable)ex);
                throw new IOException("instance error nseed", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsymmetricCipherKeyPair getKeyPairAtIndex(int index) throws InvalidWalletIndexException {
        if (!this.signKeys.containsKey(index)) {
            Object object = this.getKeyPairAtIndexLock;
            synchronized (object) {
                Ed25519KeyPairGenerator keyPairGenerator = new Ed25519KeyPairGenerator();
                if (index < 0 || index >= Integer.MAX_VALUE) {
                    throw new InvalidWalletIndexException("index outside wallet range");
                }
                keyPairGenerator.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters((SecureRandom)new SeededRandom(this.seed, "__WKCH__", index + 1)));
                this.signKeys.put(index, keyPairGenerator.generateKeyPair());
            }
        }
        return this.signKeys.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPublicKeyAtIndexURL64(int index) throws InvalidWalletIndexException, PublicKeySerializzationException {
        if (!this.hexPublicKeys.containsKey(index)) {
            Object object = this.getPublicKeyAtIndexHexLock;
            synchronized (object) {
                try {
                    AsymmetricCipherKeyPair keyPairAtIndex = this.getKeyPairAtIndex(index);
                    UrlBase64 b64e = new UrlBase64();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    AsymmetricKeyParameter aPublic = keyPairAtIndex.getPublic();
                    Ed25519PublicKeyParameters publicKey = (Ed25519PublicKeyParameters)aPublic;
                    UrlBase64.encode((byte[])publicKey.getEncoded(), (OutputStream)baos);
                    this.hexPublicKeys.put(index, baos.toString());
                    baos.close();
                }
                catch (IOException ex) {
                    log.error("Wallet can not serialize public key", (Throwable)ex);
                    throw new PublicKeySerializzationException(ex);
                }
            }
        }
        return this.hexPublicKeys.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPublicKeyAtIndexByte(int index) throws InvalidWalletIndexException, PublicKeySerializzationException {
        if (!this.bytePublicKeys.containsKey(index)) {
            Object object = this.getPublicKeyAtIndexByteLock;
            synchronized (object) {
                try {
                    AsymmetricCipherKeyPair keyPairAtIndex = this.getKeyPairAtIndex(index);
                    UrlBase64 b64e = new UrlBase64();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    AsymmetricKeyParameter aPublic = keyPairAtIndex.getPublic();
                    Ed25519PublicKeyParameters publicKey = (Ed25519PublicKeyParameters)aPublic;
                    UrlBase64.encode((byte[])publicKey.getEncoded(), (OutputStream)baos);
                    this.bytePublicKeys.put(index, baos.toByteArray());
                    baos.close();
                }
                catch (IOException ex) {
                    log.error("Wallet can not serialize public key", (Throwable)ex);
                    throw new PublicKeySerializzationException(ex);
                }
            }
        }
        return this.bytePublicKeys.get(index);
    }

    @Override
    public int compareTo(InstanceWalletKeystoreInterface t) {
        return this.getCurrentWalletID().compareTo(t.getCurrentWalletID());
    }
}

