/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.extra.identicon;

import io.takamaka.extra.identicon.IdentiBaseBlocks;
import io.takamaka.extra.identicon.IdentiColorHelper;
import io.takamaka.extra.identicon.exceptions.IdenticonException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdenticonManager {
    private static final Logger log = LoggerFactory.getLogger(IdenticonManager.class);
    private static int[][][][] blocks;

    private IdenticonManager() {
        blocks = new int[IdentiBaseBlocks.BLOCKS.length][][][];
        ConcurrentSkipListMap errors = new ConcurrentSkipListMap();
        IntStream.range(0, blocks.length).forEach(blockIndex -> {
            IdenticonManager.blocks[blockIndex] = new int[4][][];
            IntStream.range(0, 4).forEach(rotationIndex -> {
                switch (rotationIndex) {
                    case 0: {
                        IdenticonManager.blocks[blockIndex][rotationIndex] = IdentiColorHelper.clone(IdentiBaseBlocks.BLOCKS[blockIndex]);
                        break;
                    }
                    case 1: {
                        IdenticonManager.blocks[blockIndex][rotationIndex] = IdentiColorHelper.mirrorVertical(IdentiBaseBlocks.BLOCKS[blockIndex]);
                        break;
                    }
                    case 2: {
                        IdenticonManager.blocks[blockIndex][rotationIndex] = IdentiColorHelper.mirrorHorizontal(IdentiBaseBlocks.BLOCKS[blockIndex]);
                        break;
                    }
                    case 3: {
                        IdenticonManager.blocks[blockIndex][rotationIndex] = IdentiColorHelper.mirrorHplusV(IdentiBaseBlocks.BLOCKS[blockIndex]);
                        break;
                    }
                    default: {
                        String errMsg = "block " + blockIndex + " rotation " + rotationIndex;
                        log.error("rotation index out of range " + errMsg);
                        errors.put(errMsg, new IdenticonException("otation index out of range " + errMsg));
                    }
                }
            });
        });
        if (!errors.isEmpty()) {
            Map.Entry firstEntry = errors.firstEntry();
            log.error((String)firstEntry.getKey(), (Throwable)firstEntry.getValue());
            throw new RuntimeException((Throwable)firstEntry.getValue());
        }
    }

    public static IdenticonManager i() {
        return IM.I;
    }

    public int[][][][] getBlocks() {
        return blocks;
    }

    private static class IM {
        public static final IdenticonManager I = new IdenticonManager();

        private IM() {
        }
    }
}

