/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.extra.identicon;

import io.takamaka.extra.identicon.IdenticonManager;
import io.takamaka.extra.identicon.exceptions.IdenticonException;
import io.takamaka.wallet.exceptions.HashAlgorithmNotFoundException;
import io.takamaka.wallet.exceptions.HashEncodeException;
import io.takamaka.wallet.exceptions.HashProviderNotFoundException;
import io.takamaka.wallet.utils.TkmSignUtils;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentiColorHelper {
    private static final Logger log = LoggerFactory.getLogger(IdentiColorHelper.class);

    public static int cfh(String cc) {
        return Integer.parseInt(cc.substring(0, 2), 16);
    }

    public static Color fgColorFromHex(String hex) {
        return new Color(IdentiColorHelper.cfh(hex.substring(0, 2)), IdentiColorHelper.cfh(hex.substring(2, 4)), IdentiColorHelper.cfh(hex.substring(4, 6)));
    }

    public static Color bgColorFromHex(String hex) {
        int b;
        int g;
        int r = IdentiColorHelper.cfh(hex.substring(0, 2));
        if (r > 220 & (g = IdentiColorHelper.cfh(hex.substring(2, 4))) > 220 & (b = IdentiColorHelper.cfh(hex.substring(4, 6))) > 220) {
            return new Color(0, 0, 0);
        }
        return new Color(255, 255, 255);
    }

    public static int[] getRotation(String hex) {
        int[] rt = new int[]{Integer.parseInt(hex.substring(0, 1), 16) % 4, (Integer.parseInt(hex.substring(0, 1), 16) >> 2) % 4, Integer.parseInt(hex.substring(1, 2), 16) % 4, (Integer.parseInt(hex.substring(1, 2), 16) >> 2) % 4};
        return rt;
    }

    public static int[][] clone(int[][] matrix) {
        int len = matrix.length;
        int ilen = matrix.length - 1;
        int[][] mirroredMatrix = new int[len][len];
        IntStream.range(0, len).forEach(indexRow -> IntStream.range(0, len).forEach(indexCol -> {
            mirroredMatrix[indexRow][indexCol] = matrix[indexRow][indexCol];
        }));
        return mirroredMatrix;
    }

    public static int[][] mirrorVertical(int[][] matrix) {
        int len = matrix.length;
        int ilen = matrix.length - 1;
        int[][] mirroredMatrix = new int[len][len];
        IntStream.range(0, len).forEach(indexRow -> IntStream.range(0, len).forEach(indexCol -> {
            mirroredMatrix[indexRow][ilen - indexCol] = matrix[indexRow][indexCol];
        }));
        return mirroredMatrix;
    }

    public static int[][] mirrorHorizontal(int[][] matrix) {
        int len = matrix.length;
        int ilen = matrix.length - 1;
        int[][] mirroredMatrix = new int[len][len];
        IntStream.range(0, len).forEach(indexRow -> IntStream.range(0, len).forEach(indexCol -> {
            mirroredMatrix[ilen - indexRow][indexCol] = matrix[indexRow][indexCol];
        }));
        return mirroredMatrix;
    }

    public static int[][] mirrorHplusV(int[][] matrix) {
        int len = matrix.length;
        int ilen = matrix.length - 1;
        int[][] mirroredMatrix = new int[len][len];
        IntStream.range(0, len).forEach(indexRow -> IntStream.range(0, len).forEach(indexCol -> {
            mirroredMatrix[ilen - indexRow][ilen - indexCol] = matrix[indexRow][indexCol];
        }));
        return mirroredMatrix;
    }

    public static int[][] get32by32SquareBlock(String hex) {
        int blockIndex = Integer.parseInt(hex.substring(0, 1), 16);
        int[][][] block = IdenticonManager.i().getBlocks()[blockIndex];
        int[] rotation = IdentiColorHelper.getRotation(hex.substring(1, 3));
        int[][] topLeft = IdentiColorHelper.clone(block[rotation[0]]);
        int[][] topRight = IdentiColorHelper.clone(block[rotation[1]]);
        int[][] bottomRight = IdentiColorHelper.clone(block[rotation[2]]);
        int[][] bottomLeft = IdentiColorHelper.clone(block[rotation[3]]);
        return IdentiColorHelper.merge4Square(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static int[][] get64by64SquareBlockSIM(String hex) {
        int[][] squareBlock32 = IdentiColorHelper.get32by32SquareBlock(hex);
        int[][] topLeft = IdentiColorHelper.clone(squareBlock32);
        int[][] topRight = IdentiColorHelper.mirrorVertical(squareBlock32);
        int[][] bottomRight = IdentiColorHelper.mirrorHplusV(squareBlock32);
        int[][] bottomLeft = IdentiColorHelper.mirrorHorizontal(squareBlock32);
        return IdentiColorHelper.merge4Square(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static int[][] get64by64SquareBlockHIRND(String hex) {
        int[][] topLeft = IdentiColorHelper.clone(IdentiColorHelper.get32by32SquareBlock(hex.substring(0, 3)));
        int[][] topRight = IdentiColorHelper.clone(IdentiColorHelper.get32by32SquareBlock(hex.substring(3, 6)));
        int[][] bottomRight = IdentiColorHelper.clone(IdentiColorHelper.get32by32SquareBlock(hex.substring(6, 9)));
        int[][] bottomLeft = IdentiColorHelper.clone(IdentiColorHelper.get32by32SquareBlock(hex.substring(9, 12)));
        return IdentiColorHelper.merge4Square(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static int[][] get128by128SquareBlockHIRND(String hex) {
        int[][] topLeft = IdentiColorHelper.clone(IdentiColorHelper.get64by64SquareBlockHIRND(hex.substring(0, 12)));
        int[][] topRight = IdentiColorHelper.clone(IdentiColorHelper.get64by64SquareBlockHIRND(hex.substring(12, 24)));
        int[][] bottomRight = IdentiColorHelper.clone(IdentiColorHelper.get64by64SquareBlockHIRND(hex.substring(36, 48)));
        int[][] bottomLeft = IdentiColorHelper.clone(IdentiColorHelper.get64by64SquareBlockHIRND(hex.substring(48, 60)));
        return IdentiColorHelper.merge4Square(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static int[][] get256by256SquareBlockHIRND(String hex) {
        int[][] squareBlock128 = IdentiColorHelper.get128by128SquareBlockHIRND(hex.substring(0, 60));
        int[][] topLeft = IdentiColorHelper.clone(squareBlock128);
        int[][] topRight = IdentiColorHelper.mirrorVertical(squareBlock128);
        int[][] bottomRight = IdentiColorHelper.mirrorHplusV(squareBlock128);
        int[][] bottomLeft = IdentiColorHelper.mirrorHorizontal(squareBlock128);
        return IdentiColorHelper.merge4Square(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static int[][] merge4Square(int[][] topLeft, int[][] topRight, int[][] bottomRight, int[][] bottomLeft) {
        int len = topLeft.length * 2;
        int shift = len / 2;
        int[][] res = new int[len][len];
        IntStream.range(0, len).forEach(indexRow -> IntStream.range(0, len).forEach(indexCol -> {
            res[indexRow][indexCol] = indexRow < len / 2 ? (indexCol < len / 2 ? topLeft[indexRow][indexCol] : topRight[indexRow][indexCol - shift]) : (indexCol < len / 2 ? bottomLeft[indexRow - shift][indexCol] : bottomRight[indexRow - shift][indexCol - shift]);
        }));
        return res;
    }

    public static Color[][] getIdenticon256(String hex) throws IdenticonException {
        Color fg = IdentiColorHelper.fgColorFromHex(hex.substring(58, 64));
        Color bg = IdentiColorHelper.bgColorFromHex(hex.substring(58, 64));
        int[][] hrandMatrix = IdentiColorHelper.get256by256SquareBlockHIRND(hex.substring(0, 60));
        Color[][] pixelToColorSquareMatrix = IdentiColorHelper.pixelToColorSquareMatrix(fg, bg, hrandMatrix);
        return pixelToColorSquareMatrix;
    }

    public static BufferedImage scale(BufferedImage bi, float scale) {
        BufferedImage res = new BufferedImage((int)((float)bi.getWidth() * scale), (int)((float)bi.getHeight() * scale), 1);
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 3);
        res = scaleOp.filter(bi, res);
        return res;
    }

    public static BufferedImage getAvatarByString128(String value) throws IdenticonException {
        return IdentiColorHelper.scale(IdentiColorHelper.getAvatarByString256(value), 0.5f);
    }

    public static Icon getAvatarByString128Icon(String value) throws IdenticonException {
        BufferedImage avatarByString128 = IdentiColorHelper.getAvatarByString128(value);
        ImageIcon imageIcon = new ImageIcon(avatarByString128);
        return imageIcon;
    }

    public static Icon getAvatarByString256Icon(String value) throws IdenticonException {
        BufferedImage avatarByString = IdentiColorHelper.getAvatarByString256(value);
        ImageIcon imageIcon = new ImageIcon(avatarByString);
        return imageIcon;
    }

    public static BufferedImage getAvatarByString256(String value) throws IdenticonException {
        String val = value;
        try {
            if (value.length() == 19840) {
                val = TkmSignUtils.Hash384ToHex((String)value);
            }
            return IdentiColorHelper.getAvatarByHex(TkmSignUtils.Hash256ToHex((String)val));
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("hash error", ex);
            throw new IdenticonException("hash error", ex);
        }
    }

    public static String getRawAvatar256(String value) throws IdenticonException {
        String res = null;
        String val = value;
        BufferedImage avatarByString256 = null;
        try {
            avatarByString256 = IdentiColorHelper.getAvatarByHex(TkmSignUtils.Hash256ToHex((String)val));
        }
        catch (HashAlgorithmNotFoundException | HashEncodeException | HashProviderNotFoundException ex) {
            log.error("hash erro in getRawAvatar256", ex);
            throw new IdenticonException("hash erro getRawAvatar256", ex);
        }
        if (avatarByString256 != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)avatarByString256, "PNG", baos);
                res = TkmSignUtils.fromByteArrayToB64URL((byte[])baos.toByteArray());
                baos.close();
            }
            catch (IOException ex) {
                log.error("hash erro in getRawAvatar256", (Throwable)ex);
                throw new IdenticonException("hash erro in getRawAvatar256", ex);
            }
        }
        return res;
    }

    public static BufferedImage getAvatarByHex(String hex) throws IdenticonException {
        int len = 256;
        BufferedImage bi = new BufferedImage(len, len, 1);
        Color fgC = IdentiColorHelper.fgColorFromHex(hex.substring(58, 64));
        Color bgC = IdentiColorHelper.bgColorFromHex(hex.substring(58, 64));
        int fg = fgC.getRGB();
        int bg = bgC.getRGB();
        int[][] hrandMatrix = IdentiColorHelper.get256by256SquareBlockHIRND(hex.substring(0, 60));
        ConcurrentSkipListMap errors = new ConcurrentSkipListMap();
        IntStream.range(0, len).forEach(indexRow -> IntStream.range(0, len).forEach(indexCol -> {
            switch (hrandMatrix[indexRow][indexCol]) {
                case 0: {
                    bi.setRGB(indexRow, indexCol, bg);
                    break;
                }
                case 1: {
                    bi.setRGB(indexRow, indexCol, fg);
                    break;
                }
                default: {
                    String errMsg = "row " + indexRow + " col " + indexCol;
                    log.error("color index out of range " + errMsg);
                    errors.put(errMsg, new IdenticonException("color index out of range " + errMsg));
                }
            }
        }));
        if (!errors.isEmpty()) {
            Map.Entry firstEntry = errors.firstEntry();
            log.error((String)firstEntry.getKey(), (Throwable)firstEntry.getValue());
            throw (IdenticonException)firstEntry.getValue();
        }
        return bi;
    }

    public static Color[][] pixelToColorSquareMatrix(Color fg, Color bg, int[][] m) throws IdenticonException {
        int len = m.length;
        Color[][] res = new Color[len][len];
        ConcurrentSkipListMap errors = new ConcurrentSkipListMap();
        IntStream.range(0, len).forEach(indexRow -> IntStream.range(0, len).forEach(indexCol -> {
            switch (m[indexRow][indexCol]) {
                case 0: {
                    res[indexRow][indexCol] = bg;
                    break;
                }
                case 1: {
                    res[indexRow][indexCol] = fg;
                    break;
                }
                default: {
                    String errMsg = "row " + indexRow + " col " + indexCol;
                    log.error("COLOR INDEX OUT OF RANGE " + errMsg);
                    errors.put(errMsg, new IdenticonException("COLOR INDEX OUT OF RANGE " + errMsg));
                }
            }
        }));
        if (!errors.isEmpty()) {
            Map.Entry firstEntry = errors.firstEntry();
            log.error((String)firstEntry.getKey(), (Throwable)firstEntry.getValue());
            throw (IdenticonException)firstEntry.getValue();
        }
        return res;
    }

    public static void createIdentiMatrix(String hex) {
        Color[] foreground = new Color[4];
        Color[] background = new Color[4];
    }

    public static void printMatrix(int[][] m) {
        IntStream.range(0, m.length).forEachOrdered(rIndex -> {
            IntStream.range(0, m[rIndex].length).forEachOrdered(cIndex -> System.out.print(m[rIndex][cIndex]));
            System.out.println("");
        });
        System.out.println("");
    }
}

