/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.extra.files;

import io.takamaka.extra.beans.TkmMetadata;
import io.takamaka.wallet.utils.TkmSignUtils;
import io.takamaka.wallet.utils.TkmTextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MetadataUtils {
    private static final Logger log = LoggerFactory.getLogger(MetadataUtils.class);

    public static final String getOsIdentifyingString() {
        return System.getProperty("os.name");
    }

    public static final TkmMetadata collectMetadata(FileInputStream fileIn, String[] tags) throws IOException, SAXException, TikaException {
        TkmMetadata tkmMetadata = new TkmMetadata();
        Metadata extractMetadatatUsingParser = MetadataUtils.extractMetadatatUsingParser(fileIn, tkmMetadata);
        String[] names = extractMetadatatUsingParser.names();
        HashMap<String, String> mappedMetaData = new HashMap<String, String>();
        HashMap mappedExtraMetadata = new HashMap();
        for (String name : names) {
            mappedMetaData.put(name, extractMetadatatUsingParser.get(name));
        }
        ArrayList<String> tagsArray = new ArrayList<String>();
        if (tags != null && tags.length != 0) {
            for (String tag : tags) {
                String trimmedTag = StringUtils.trimToNull((String)tag);
                if (TkmTextUtils.isNullOrBlank((String)trimmedTag)) continue;
                tagsArray.add(trimmedTag);
            }
        }
        tkmMetadata.setTags((String[])tagsArray.toArray(String[]::new));
        ConcurrentSkipListMap<String, String> extraMetadata = new ConcurrentSkipListMap<String, String>();
        mappedMetaData.entrySet().forEach(single -> {
            try {
                switch ((String)single.getKey()) {
                    case "Content-Type": 
                    case "mime": {
                        tkmMetadata.setContentType((String)single.getValue());
                        tkmMetadata.setMime((String)single.getValue());
                        break;
                    }
                    case "X-Parsed-By": {
                        tkmMetadata.setContentType((String)single.getValue());
                        break;
                    }
                    default: {
                        extraMetadata.put((String)single.getKey(), (String)single.getValue());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                log.warn("Unreadable metadata", (Throwable)ex);
            }
        });
        tkmMetadata.setExtraMetadata(extraMetadata);
        tkmMetadata.setPlatform(MetadataUtils.getOsIdentifyingString());
        tkmMetadata.setType("raw");
        return tkmMetadata;
    }

    public static final String fromFileToB64String(File selectedFile) throws IOException {
        byte[] byteFile = FileUtils.readFileToByteArray((File)selectedFile);
        return TkmSignUtils.fromByteArrayToB64URL((byte[])byteFile);
    }

    public static final Metadata extractMetadatatUsingParser(InputStream stream, TkmMetadata tkmMetadata) throws IOException, SAXException, TikaException {
        AutoDetectParser parser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        parser.parse(stream, (ContentHandler)handler, metadata, context);
        tkmMetadata.setXParsedBy(parser.getClass().getName());
        return metadata;
    }
}

