/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.crypto.tkmsecurityprovider.util.adaptor.v1;

import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.rainbowV1.RainbowPublicKeyParameters;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.rainbowV1.RainbowSigner;
import io.takamaka.crypto.tkmsecurityprovider.util.adaptor.v1.RainbowCypherBeanV1;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.UrlBase64;

public class Rainbow1CypherProvider {
    public static final RainbowCypherBeanV1 sign(AsymmetricCipherKeyPair keyPair, String message) {
        RainbowCypherBeanV1 tcb = new RainbowCypherBeanV1();
        tcb.setValid(false);
        try {
            byte[] byteMessage = Strings.toByteArray(message);
            RainbowSigner signer = new RainbowSigner();
            signer.init(true, keyPair.getPrivate());
            byte[] generatedSignature = signer.generateSignature(byteMessage);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.encode(generatedSignature, baos);
            tcb.setSignature(baos.toString());
            tcb.setValid(true);
            baos.close();
        }
        catch (IOException ex) {
            tcb.setEx(ex);
            tcb.setValid(false);
        }
        return tcb;
    }

    public static final RainbowCypherBeanV1 verify(AsymmetricCipherKeyPair keyPair, String signature, String message) {
        RainbowCypherBeanV1 tcb = new RainbowCypherBeanV1();
        tcb.setValid(false);
        RainbowPublicKeyParameters publicK = null;
        byte[] signatureByteArray = new byte[]{};
        byte[] messageByteArray = new byte[]{};
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UrlBase64.decode(signature, (OutputStream)baos);
            signatureByteArray = baos.toByteArray();
            messageByteArray = Strings.toByteArray(message);
            RainbowSigner verifier = new RainbowSigner();
            publicK = (RainbowPublicKeyParameters)keyPair.getPublic();
            verifier.init(false, publicK);
            boolean validSignature = verifier.verifySignature(messageByteArray, signatureByteArray);
            tcb.setValid(validSignature);
            baos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            if (publicK != null) {
                System.out.println(publicK.getCoeffQuadratic().toString());
            }
            System.out.println(signature);
            System.out.println(Arrays.toString(signatureByteArray));
            System.out.println(Arrays.toString(messageByteArray));
            tcb.setEx(ex);
            tcb.setValid(false);
        }
        return tcb;
    }
}

