/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.crypto.tkmsecurityprovider.util.adaptor.r2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAKeyPairGenerator;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.provider.qtesla.QTESLAKeyFactorySpi;
import org.bouncycastle.util.encoders.UrlBase64;

public class QTR2KeyPairGenerator {
    public static Signature signature;
    public static final Object SIGLOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair internalJavaKeypairFromBCPostQuantumKeyPair(AsymmetricCipherKeyPair ackp) throws IOException {
        Object object = SIGLOCK;
        synchronized (object) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(ackp.getPrivate());
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(ackp.getPublic());
            PrivateKey privateKey = BouncyCastlePQCProvider.getPrivateKey(privateKeyInfo);
            PublicKey publicKey = BouncyCastlePQCProvider.getPublicKey(publicKeyInfo);
            return new KeyPair(publicKey, privateKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] internalSigner(PrivateKey priv, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object = SIGLOCK;
        synchronized (object) {
            Signature sigInstance = QTR2KeyPairGenerator.getSignatureInstance();
            sigInstance.initSign(priv);
            sigInstance.update(data);
            return sigInstance.sign();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean internalVerifier(PublicKey pub, byte[] signature, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object = SIGLOCK;
        synchronized (object) {
            Signature sigInstance = QTR2KeyPairGenerator.getSignatureInstance();
            sigInstance.initVerify(pub);
            sigInstance.update(data);
            return sigInstance.verify(signature);
        }
    }

    public static Signature getSignatureInstance() throws NoSuchAlgorithmException {
        BouncyCastlePQCProvider bouncyCastlePQCProvider = new BouncyCastlePQCProvider();
        return Signature.getInstance("QTESLA-P-I", bouncyCastlePQCProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey internalPublicKeyFromEncoded(byte[] encoded) throws InvalidKeySpecException {
        Object object = SIGLOCK;
        synchronized (object) {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encoded);
            QTESLAKeyFactorySpi qfs = new QTESLAKeyFactorySpi();
            return qfs.engineGeneratePublic(pubKeySpec);
        }
    }

    public PublicKey publicKeyFromEncoded(byte[] encoded) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encoded);
        switch (encoded.length) {
            case 14904: {
                QTESLAKeyFactorySpi qfs = new QTESLAKeyFactorySpi();
                return qfs.engineGeneratePublic(pubKeySpec);
            }
        }
        throw new UnsupportedOperationException("key not recognized");
    }

    public static QTESLAKeyPairGenerator getGenerator() {
        return new QTESLAKeyPairGenerator();
    }

    public static QTESLAKeyGenerationParameters getGenerationParameters(SecureRandom sr) {
        return new QTESLAKeyGenerationParameters(5, sr);
    }

    public static AsymmetricCipherKeyPair getKeyPair(SecureRandom sr) {
        QTESLAKeyGenerationParameters generationParameters = QTR2KeyPairGenerator.getGenerationParameters(sr);
        QTESLAKeyPairGenerator generator = QTR2KeyPairGenerator.getGenerator();
        generator.init(generationParameters);
        return generator.generateKeyPair();
    }

    public static String getStringPublicKey(AsymmetricCipherKeyPair ackp) throws IOException {
        UrlBase64 b64e = new UrlBase64();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AsymmetricKeyParameter aPublic = ackp.getPublic();
        QTESLAPublicKeyParameters qtPubKey = (QTESLAPublicKeyParameters)aPublic;
        UrlBase64.encode(qtPubKey.getPublicData(), baos);
        String stringPublicKey = baos.toString();
        baos.close();
        return stringPublicKey;
    }

    public static byte[] getBytePublicKey(AsymmetricCipherKeyPair ackp) throws IOException {
        UrlBase64 b64e = new UrlBase64();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AsymmetricKeyParameter aPublic = ackp.getPublic();
        QTESLAPublicKeyParameters qtPubKey = (QTESLAPublicKeyParameters)aPublic;
        UrlBase64.encode(qtPubKey.getPublicData(), baos);
        byte[] toByteArray = baos.toByteArray();
        baos.close();
        return toByteArray;
    }

    static {
        SIGLOCK = new Object();
    }
}

