/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1;

import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.QTESLA;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.QTESLAKeyGenerationParameters;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.QTESLAPrivateKeyParameters;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.QTESLAPublicKeyParameters;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.QTESLASecurityCategory;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;

public final class QTESLAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private int securityCategory;
    private SecureRandom secureRandom;

    @Override
    public void init(KeyGenerationParameters param) {
        QTESLAKeyGenerationParameters parameters = (QTESLAKeyGenerationParameters)param;
        this.secureRandom = parameters.getRandom();
        this.securityCategory = parameters.getSecurityCategory();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] privateKey = this.allocatePrivate(this.securityCategory);
        byte[] publicKey = this.allocatePublic(this.securityCategory);
        switch (this.securityCategory) {
            case 0: {
                QTESLA.generateKeyPairI(publicKey, privateKey, this.secureRandom);
                break;
            }
            case 1: {
                QTESLA.generateKeyPairIIISize(publicKey, privateKey, this.secureRandom);
                break;
            }
            case 2: {
                QTESLA.generateKeyPairIIISpeed(publicKey, privateKey, this.secureRandom);
                break;
            }
            case 3: {
                QTESLA.generateKeyPairIP(publicKey, privateKey, this.secureRandom);
                break;
            }
            case 4: {
                QTESLA.generateKeyPairIIIP(publicKey, privateKey, this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.securityCategory);
            }
        }
        return new AsymmetricCipherKeyPair(new QTESLAPublicKeyParameters(this.securityCategory, publicKey), new QTESLAPrivateKeyParameters(this.securityCategory, privateKey));
    }

    private byte[] allocatePrivate(int securityCategory) {
        return new byte[QTESLASecurityCategory.getPrivateSize(securityCategory)];
    }

    private byte[] allocatePublic(int securityCategory) {
        return new byte[QTESLASecurityCategory.getPublicSize(securityCategory)];
    }
}

