/*
 * Decompiled with CFR 0.152.
 */
package io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1;

import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.CommonFunction;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.HashUtils;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.PolynomialHeuristic;
import io.takamaka.crypto.tkmsecurityprovider.pqc.crypto.qteslaround1.PolynomialProvablySecure;
import io.takamaka.crypto.tkmsecurityprovider.util.Arrays;

class Polynomial {
    public static final int RANDOM = 32;
    public static final int SEED = 32;
    public static final int HASH = 32;
    public static final int MESSAGE = 64;
    public static final int SIGNATURE_I = 1376;
    public static final int SIGNATURE_III_SIZE = 2720;
    public static final int SIGNATURE_III_SPEED = 2848;
    public static final int SIGNATURE_I_P = 2848;
    public static final int SIGNATURE_III_P = 6176;
    public static final int PUBLIC_KEY_I = 1504;
    public static final int PUBLIC_KEY_III_SIZE = 2976;
    public static final int PUBLIC_KEY_III_SPEED = 3104;
    public static final int PUBLIC_KEY_I_P = 14880;
    public static final int PUBLIC_KEY_III_P = 39712;
    public static final int PRIVATE_KEY_I = 1344;
    public static final int PRIVATE_KEY_III_SIZE = 2112;
    public static final int PRIVATE_KEY_III_SPEED = 2368;
    public static final int PRIVATE_KEY_I_P = 5184;
    public static final int PRIVATE_KEY_III_P = 12352;

    Polynomial() {
    }

    private static int montgomery(long number, int q, long qInverse) {
        return (int)(number + (number * qInverse & 0xFFFFFFFFL) * (long)q >> 32);
    }

    private static long montgomeryP(long number, int q, long qInverse) {
        return number + (number * qInverse & 0xFFFFFFFFL) * (long)q >> 32;
    }

    public static int barrett(int number, int q, int barrettMultiplication, int barrettDivision) {
        return number - (int)((long)number * (long)barrettMultiplication >> barrettDivision) * q;
    }

    public static long barrett(long number, int q, int barrettMultiplication, int barrettDivision) {
        return number - (number * (long)barrettMultiplication >> barrettDivision) * (long)q;
    }

    private static void numberTheoreticTransform(int[] destination, int[] source, int n, int q, long qInverse) {
        int jTwiddle = 0;
        for (int numberOfProblem = n >> 1; numberOfProblem > 0; numberOfProblem >>= 1) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < n) {
                long omega = source[jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    int temporary = Polynomial.montgomery(omega * (long)destination[j + numberOfProblem], q, qInverse);
                    destination[j + numberOfProblem] = destination[j] - temporary;
                    destination[j] = destination[j] + temporary;
                }
                jFirst = j + numberOfProblem;
            }
        }
    }

    private static void numberTheoreticTransformIP(long[] destination, long[] source) {
        int jTwiddle = 0;
        for (int numberOfProblem = 512; numberOfProblem > 0; numberOfProblem >>= 1) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < 1024) {
                long omega = source[jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    long temporary = Polynomial.montgomeryP(omega * destination[j + numberOfProblem], 485978113, 3421990911L);
                    destination[j + numberOfProblem] = destination[j] + (485978113L - temporary);
                    destination[j] = destination[j] + temporary;
                }
                jFirst = j + numberOfProblem;
            }
        }
    }

    private static void numberTheoreticTransformIIIP(long[] destination, long[] source) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1024; numberOfProblem > 0; numberOfProblem >>= 1) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < 2048) {
                int omega = (int)source[jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    long temporary = Polynomial.barrett(Polynomial.montgomeryP((long)omega * destination[j + numberOfProblem], 1129725953, 861290495L), 1129725953, 15, 34);
                    destination[j + numberOfProblem] = Polynomial.barrett(destination[j] + (2259451906L - temporary), 1129725953, 15, 34);
                    destination[j] = Polynomial.barrett(destination[j] + temporary, 1129725953, 15, 34);
                }
                jFirst = j + numberOfProblem;
            }
        }
    }

    private static void inverseNumberTheoreticTransformI(int[] destination, int[] source) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1; numberOfProblem < 512; numberOfProblem *= 2) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < 512) {
                long omega = source[jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    int temporary = destination[j];
                    destination[j] = temporary + destination[j + numberOfProblem];
                    destination[j + numberOfProblem] = Polynomial.montgomery(omega * (long)(temporary - destination[j + numberOfProblem]), 4205569, 3098553343L);
                }
                jFirst = j + numberOfProblem;
            }
        }
        for (int i = 0; i < 256; ++i) {
            destination[i] = Polynomial.montgomery(1081347L * (long)destination[i], 4205569, 3098553343L);
        }
    }

    private static void inverseNumberTheoreticTransform(int[] destination, int[] source, int n, int q, long qInverse, int r, int barrettMultiplication, int barrettDivision) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1; numberOfProblem < n; numberOfProblem *= 2) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < n) {
                long omega = source[jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    int temporary = destination[j];
                    destination[j] = numberOfProblem == 16 ? Polynomial.barrett(temporary + destination[j + numberOfProblem], q, barrettMultiplication, barrettDivision) : temporary + destination[j + numberOfProblem];
                    destination[j + numberOfProblem] = Polynomial.montgomery(omega * (long)(temporary - destination[j + numberOfProblem]), q, qInverse);
                }
                jFirst = j + numberOfProblem;
            }
        }
        for (int i = 0; i < n / 2; ++i) {
            destination[i] = Polynomial.montgomery((long)r * (long)destination[i], q, qInverse);
        }
    }

    private static void inverseNumberTheoreticTransformIP(long[] destination, int destinationOffset, long[] source, int sourceOffset) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1; numberOfProblem < 1024; numberOfProblem *= 2) {
            long temporary;
            long omega;
            int j = 0;
            int jFirst = 0;
            while (jFirst < 1024) {
                omega = source[sourceOffset + jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    temporary = destination[destinationOffset + j];
                    destination[destinationOffset + j] = temporary + destination[destinationOffset + j + numberOfProblem];
                    destination[destinationOffset + j + numberOfProblem] = Polynomial.montgomeryP(omega * (temporary + (971956226L - destination[destinationOffset + j + numberOfProblem])), 485978113, 3421990911L);
                }
                jFirst = j + numberOfProblem;
            }
            numberOfProblem *= 2;
            jFirst = 0;
            while (jFirst < 1024) {
                omega = source[sourceOffset + jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    temporary = destination[destinationOffset + j];
                    destination[destinationOffset + j] = Polynomial.barrett(temporary + destination[destinationOffset + j + numberOfProblem], 485978113, 1, 29);
                    destination[destinationOffset + j + numberOfProblem] = Polynomial.montgomeryP(omega * (temporary + (971956226L - destination[destinationOffset + j + numberOfProblem])), 485978113, 3421990911L);
                }
                jFirst = j + numberOfProblem;
            }
        }
    }

    private static void inverseNumberTheoreticTransformIIIP(long[] destination, int destinationOffset, long[] source, int sourceOffset) {
        int jTwiddle = 0;
        for (int numberOfProblem = 1; numberOfProblem < 2048; numberOfProblem *= 2) {
            int j = 0;
            int jFirst = 0;
            while (jFirst < 2048) {
                long omega = source[sourceOffset + jTwiddle++];
                for (j = jFirst; j < jFirst + numberOfProblem; ++j) {
                    long temporary = destination[destinationOffset + j];
                    destination[destinationOffset + j] = Polynomial.barrett(temporary + destination[destinationOffset + j + numberOfProblem], 1129725953, 15, 34);
                    destination[destinationOffset + j + numberOfProblem] = Polynomial.barrett(Polynomial.montgomeryP(omega * (temporary + (2259451906L - destination[destinationOffset + j + numberOfProblem])), 1129725953, 861290495L), 1129725953, 15, 34);
                }
                jFirst = j + numberOfProblem;
            }
        }
    }

    private static void componentWisePolynomialMultiplication(int[] product, int[] multiplicand, int[] multiplier, int n, int q, long qInverse) {
        for (int i = 0; i < n; ++i) {
            product[i] = Polynomial.montgomery((long)multiplicand[i] * (long)multiplier[i], q, qInverse);
        }
    }

    private static void componentWisePolynomialMultiplication(long[] product, int productOffset, long[] multiplicand, int multiplicandOffset, long[] multiplier, int multiplierOffset, int n, int q, long qInverse) {
        for (int i = 0; i < n; ++i) {
            product[productOffset + i] = Polynomial.montgomeryP(multiplicand[multiplicandOffset + i] * multiplier[multiplierOffset + i], q, qInverse);
        }
    }

    public static void polynomialNumberTheoreticTransform(long[] arrayNumberTheoreticTransform, long[] array, int n) {
        for (int i = 0; i < n; ++i) {
            arrayNumberTheoreticTransform[i] = array[i];
        }
        if (n == 1024) {
            Polynomial.numberTheoreticTransformIP(arrayNumberTheoreticTransform, PolynomialProvablySecure.ZETA_I_P);
        }
        if (n == 2048) {
            Polynomial.numberTheoreticTransformIIIP(arrayNumberTheoreticTransform, PolynomialProvablySecure.ZETA_III_P);
        }
    }

    public static void polynomialMultiplication(int[] product, int[] multiplicand, int[] multiplier, int n, int q, long qInverse, int[] zeta) {
        int[] multiplierNumberTheoreticTransform = new int[n];
        for (int i = 0; i < n; ++i) {
            multiplierNumberTheoreticTransform[i] = multiplier[i];
        }
        Polynomial.numberTheoreticTransform(multiplierNumberTheoreticTransform, zeta, n, q, qInverse);
        Polynomial.componentWisePolynomialMultiplication(product, multiplicand, multiplierNumberTheoreticTransform, n, q, qInverse);
        if (q == 4205569) {
            Polynomial.inverseNumberTheoreticTransformI(product, PolynomialHeuristic.ZETA_INVERSE_I);
        }
        if (q == 4206593) {
            Polynomial.inverseNumberTheoreticTransform(product, PolynomialHeuristic.ZETA_INVERSE_III_SIZE, 1024, 4206593, 4148178943L, 35843, 1021, 32);
        }
        if (q == 8404993) {
            Polynomial.inverseNumberTheoreticTransform(product, PolynomialHeuristic.ZETA_INVERSE_III_SPEED, 1024, 8404993, 4034936831L, 15873, 511, 32);
        }
    }

    public static void polynomialMultiplication(long[] product, int productOffset, long[] multiplicand, int multiplicandOffset, long[] multiplier, int multiplierOffset, int n, int q, long qInverse) {
        Polynomial.componentWisePolynomialMultiplication(product, productOffset, multiplicand, multiplicandOffset, multiplier, multiplierOffset, n, q, qInverse);
        if (q == 485978113) {
            Polynomial.inverseNumberTheoreticTransformIP(product, productOffset, PolynomialProvablySecure.ZETA_INVERSE_I_P, 0);
        }
        if (q == 1129725953) {
            Polynomial.inverseNumberTheoreticTransformIIIP(product, productOffset, PolynomialProvablySecure.ZETA_INVERSE_III_P, 0);
        }
    }

    public static void polynomialAddition(int[] summation, int[] augend, int[] addend, int n) {
        for (int i = 0; i < n; ++i) {
            summation[i] = augend[i] + addend[i];
        }
    }

    public static void polynomialAddition(long[] summation, int summationOffset, long[] augend, int augendOffset, long[] addend, int addendOffset, int n) {
        for (int i = 0; i < n; ++i) {
            summation[summationOffset + i] = augend[augendOffset + i] + addend[addendOffset + i];
        }
    }

    public static void polynomialAdditionCorrection(int[] summation, int[] augend, int[] addend, int n, int q) {
        for (int i = 0; i < n; ++i) {
            summation[i] = augend[i] + addend[i];
            int n2 = i;
            summation[n2] = summation[n2] + (summation[i] >> 31 & q);
            int n3 = i;
            summation[n3] = summation[n3] - q;
            int n4 = i;
            summation[n4] = summation[n4] + (summation[i] >> 31 & q);
        }
    }

    public static void polynomialSubtractionCorrection(int[] difference, int[] minuend, int[] subtrahend, int n, int q) {
        for (int i = 0; i < n; ++i) {
            difference[i] = minuend[i] - subtrahend[i];
            int n2 = i;
            difference[n2] = difference[n2] + (difference[i] >> 31 & q);
        }
    }

    public static void polynomialSubtractionMontgomery(int[] difference, int[] minuend, int[] subtrahend, int n, int q, long qInverse, int r) {
        for (int i = 0; i < n; ++i) {
            difference[i] = Polynomial.montgomery((long)r * (long)(minuend[i] - subtrahend[i]), q, qInverse);
        }
    }

    public static void polynomialSubtraction(long[] difference, int differenceOffset, long[] minuend, int minuendOffset, long[] subtrahend, int subtrahendOffset, int n, int q, int barrettMultiplication, int barrettDivision) {
        for (int i = 0; i < n; ++i) {
            difference[differenceOffset + i] = Polynomial.barrett(minuend[minuendOffset + i] - subtrahend[subtrahendOffset + i], q, barrettMultiplication, barrettDivision);
        }
    }

    public static void polynomialUniform(int[] A, byte[] seed, int seedOffset, int n, int q, long qInverse, int qLogarithm, int generatorA, int inverseNumberTheoreticTransform) {
        int position = 0;
        int i = 0;
        int numberOfByte = (qLogarithm + 7) / 8;
        int numberOfBlock = generatorA;
        short dualModeSampler = 0;
        int mask = (1 << qLogarithm) - 1;
        byte[] buffer = new byte[168 * generatorA];
        short s = dualModeSampler;
        dualModeSampler = (short)(dualModeSampler + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(buffer, 0, 168 * generatorA, s, seed, seedOffset, 32);
        while (i < n) {
            if (position > 168 * numberOfBlock - 4 * numberOfByte) {
                numberOfBlock = 1;
                short s2 = dualModeSampler;
                dualModeSampler = (short)(dualModeSampler + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(buffer, 0, 168 * numberOfBlock, s2, seed, seedOffset, 32);
                position = 0;
            }
            int value1 = CommonFunction.load32(buffer, position) & mask;
            int value2 = CommonFunction.load32(buffer, position += numberOfByte) & mask;
            int value3 = CommonFunction.load32(buffer, position += numberOfByte) & mask;
            int value4 = CommonFunction.load32(buffer, position += numberOfByte) & mask;
            position += numberOfByte;
            if (value1 < q && i < n) {
                A[i++] = Polynomial.montgomery((long)value1 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value2 < q && i < n) {
                A[i++] = Polynomial.montgomery((long)value2 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value3 < q && i < n) {
                A[i++] = Polynomial.montgomery((long)value3 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value4 >= q || i >= n) continue;
            A[i++] = Polynomial.montgomery((long)value4 * (long)inverseNumberTheoreticTransform, q, qInverse);
        }
    }

    public static void polynomialUniform(long[] A, byte[] seed, int seedOffset, int n, int k, int q, long qInverse, int qLogarithm, int generatorA, int inverseNumberTheoreticTransform) {
        int position = 0;
        int i = 0;
        int numberOfByte = (qLogarithm + 7) / 8;
        int numberOfBlock = generatorA;
        short dualModeSampler = 0;
        int mask = (1 << qLogarithm) - 1;
        byte[] buffer = new byte[168 * numberOfBlock];
        short s = dualModeSampler;
        dualModeSampler = (short)(dualModeSampler + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(buffer, 0, 168 * numberOfBlock, s, seed, seedOffset, 32);
        while (i < n * k) {
            if (position > 168 * numberOfBlock - 4 * numberOfByte) {
                numberOfBlock = 1;
                short s2 = dualModeSampler;
                dualModeSampler = (short)(dualModeSampler + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(buffer, 0, 168 * numberOfBlock, s2, seed, seedOffset, 32);
                position = 0;
            }
            int value1 = CommonFunction.load32(buffer, position) & mask;
            int value2 = CommonFunction.load32(buffer, position += numberOfByte) & mask;
            int value3 = CommonFunction.load32(buffer, position += numberOfByte) & mask;
            int value4 = CommonFunction.load32(buffer, position += numberOfByte) & mask;
            position += numberOfByte;
            if (value1 < q && i < n * k) {
                A[i++] = Polynomial.montgomeryP((long)value1 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value2 < q && i < n * k) {
                A[i++] = Polynomial.montgomeryP((long)value2 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value3 < q && i < n * k) {
                A[i++] = Polynomial.montgomeryP((long)value3 * (long)inverseNumberTheoreticTransform, q, qInverse);
            }
            if (value4 >= q || i >= n * k) continue;
            A[i++] = Polynomial.montgomeryP((long)value4 * (long)inverseNumberTheoreticTransform, q, qInverse);
        }
    }

    public static void sparsePolynomialMultiplication16(int[] product, short[] privateKey, int[] positionList, short[] signList, int n, int h) {
        Arrays.fill(product, 0);
        for (int i = 0; i < h; ++i) {
            int j;
            int position = positionList[i];
            for (j = 0; j < position; ++j) {
                int n2 = j;
                product[n2] = product[n2] - signList[i] * privateKey[n + j - position];
            }
            for (j = position; j < n; ++j) {
                int n3 = j;
                product[n3] = product[n3] + signList[i] * privateKey[j - position];
            }
        }
    }

    public static void sparsePolynomialMultiplication8(long[] product, int productOffset, byte[] privateKey, int privateKeyOffset, int[] positionList, short[] signList, int n, int h) {
        Arrays.fill(product, 0L);
        for (int i = 0; i < h; ++i) {
            int j;
            int position = positionList[i];
            for (j = 0; j < position; ++j) {
                int n2 = productOffset + j;
                product[n2] = product[n2] - (long)(signList[i] * privateKey[privateKeyOffset + n + j - position]);
            }
            for (j = position; j < n; ++j) {
                int n3 = productOffset + j;
                product[n3] = product[n3] + (long)(signList[i] * privateKey[privateKeyOffset + j - position]);
            }
        }
    }

    public static void sparsePolynomialMultiplication32(int[] product, int[] publicKey, int[] positionList, short[] signList, int n, int h) {
        Arrays.fill(product, 0);
        for (int i = 0; i < h; ++i) {
            int j;
            int position = positionList[i];
            for (j = 0; j < position; ++j) {
                int n2 = j;
                product[n2] = product[n2] - signList[i] * publicKey[n + j - position];
            }
            for (j = position; j < n; ++j) {
                int n3 = j;
                product[n3] = product[n3] + signList[i] * publicKey[j - position];
            }
        }
    }

    public static void sparsePolynomialMultiplication32(long[] product, int productOffset, int[] publicKey, int publicKeyOffset, int[] positionList, short[] signList, int n, int h, int q, int barrettMultiplication, int barrettDivision) {
        int i;
        Arrays.fill(product, 0L);
        for (i = 0; i < h; ++i) {
            int j;
            int position = positionList[i];
            for (j = 0; j < position; ++j) {
                int n2 = productOffset + j;
                product[n2] = product[n2] - (long)(signList[i] * publicKey[publicKeyOffset + n + j - position]);
            }
            for (j = position; j < n; ++j) {
                int n3 = productOffset + j;
                product[n3] = product[n3] + (long)(signList[i] * publicKey[publicKeyOffset + j - position]);
            }
        }
        for (i = 0; i < n; ++i) {
            product[productOffset + i] = Polynomial.barrett(product[productOffset + i], q, barrettMultiplication, barrettDivision);
        }
    }
}

