/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigProducerUtil {
    private ConfigProducerUtil() {
    }

    public static <T> Optional<T> optionalConfigValue(InjectionPoint injectionPoint, Config config) {
        Type type = injectionPoint.getAnnotated().getBaseType();
        Class<T> valueType = ConfigProducerUtil.resolveValueType(type);
        return Optional.ofNullable(ConfigProducerUtil.getValue(injectionPoint, valueType, config));
    }

    private static <T> Class<T> resolveValueType(Type type) {
        Class valueType;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = ConfigProducerUtil.unwrapType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        return valueType;
    }

    public static <C extends Collection<T>, T> C collectionConfigProperty(InjectionPoint injectionPoint, Config config, IntFunction<C> factory) {
        Type type = injectionPoint.getAnnotated().getBaseType();
        Class<T> valueType = ConfigProducerUtil.resolveValueType(type);
        String name = ConfigProducerUtil.getName(injectionPoint);
        SmallRyeConfig src = (SmallRyeConfig)config;
        try {
            if (name == null) {
                return null;
            }
            Converter<C> converter = Converters.newCollectionConverter(src.getConverter(valueType), factory);
            Optional<C> optionalValue = src.getOptionalValue(name, converter);
            if (optionalValue.isPresent()) {
                return (C)((Collection)optionalValue.get());
            }
            String defaultValue = ConfigProducerUtil.getDefaultValue(injectionPoint);
            if (defaultValue != null && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                return (C)((Collection)converter.convert(defaultValue));
            }
            return (C)((Collection)factory.apply(0));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static <T> Class<T> unwrapType(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return (Class)type;
    }

    public static <T> T getValue(InjectionPoint injectionPoint, Class<T> target, Config config) {
        String name = ConfigProducerUtil.getName(injectionPoint);
        try {
            if (name == null) {
                return null;
            }
            Optional optionalValue = config.getOptionalValue(name, target);
            if (optionalValue.isPresent()) {
                return optionalValue.get();
            }
            String defaultValue = ConfigProducerUtil.getDefaultValue(injectionPoint);
            if (defaultValue != null && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                return ((SmallRyeConfig)config).convert(defaultValue, target);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            ConfigProperty configProperty = (ConfigProperty)qualifier;
            return ConfigExtension.getConfigKey(injectionPoint, configProperty);
        }
        return null;
    }

    private static String getDefaultValue(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            return ((ConfigProperty)qualifier).defaultValue();
        }
        return null;
    }
}

