/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.devpack;

import io.neow3j.devpack.ByteString;
import io.neow3j.devpack.ECPoint;
import io.neow3j.devpack.Hash160;
import io.neow3j.devpack.List;
import io.neow3j.devpack.Map;
import io.neow3j.devpack.annotations.Instruction;
import io.neow3j.script.OpCode;

public class Manifest {
    public String name = null;
    public List<Group> groups = null;
    public Map<String, String> features = null;
    public List<String> supportedStandards = null;
    public ABI abi = null;
    public List<Permission> permissions = null;
    public List<Hash160> trusts = null;
    public Object extra = null;

    private Manifest() {
    }

    @Instruction(opcode=OpCode.EQUAL)
    public native boolean equals(Object var1);

    public boolean equals(Manifest m) {
        int i;
        if (this == m) {
            return true;
        }
        if (this.name != m.name || this.extra != m.extra || !this.abi.equals(m.abi)) {
            return false;
        }
        if (this.groups != m.groups) {
            if (this.groups.size() != m.groups.size()) {
                return false;
            }
            for (i = 0; i < this.groups.size(); ++i) {
                if (this.groups.get(i).equals(m.groups.get(i))) continue;
                return false;
            }
        }
        if (this.features != m.features) {
            String[] otherKeys;
            String[] thisKeys = this.features.keys();
            if (thisKeys.length != (otherKeys = m.features.keys()).length) {
                return false;
            }
            String[] thisValues = this.features.values();
            String[] otherValues = m.features.values();
            for (int i2 = 0; i2 < thisKeys.length; ++i2) {
                if (thisKeys[i2] == otherKeys[i2] && thisValues[i2] == otherValues[i2]) continue;
                return false;
            }
        }
        if (this.supportedStandards != m.supportedStandards) {
            if (this.supportedStandards.size() != m.supportedStandards.size()) {
                return false;
            }
            for (i = 0; i < this.supportedStandards.size(); ++i) {
                if (this.supportedStandards.get(i) == m.supportedStandards.get(i)) continue;
                return false;
            }
        }
        if (this.permissions != m.permissions) {
            if (this.permissions.size() != m.permissions.size()) {
                return false;
            }
            for (i = 0; i < this.permissions.size(); ++i) {
                if (this.permissions.get(i).equals(m.permissions.get(i))) continue;
                return false;
            }
        }
        if (this.trusts != m.trusts) {
            if (this.trusts.size() != m.trusts.size()) {
                return false;
            }
            for (i = 0; i < this.trusts.size(); ++i) {
                if (this.trusts.get(i) == m.trusts.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public static class Permission {
        public Hash160 contract = null;
        public List<String> methods = null;

        public boolean equals(Permission p) {
            if (this == p) {
                return true;
            }
            if (this.contract != p.contract) {
                return false;
            }
            if (this.methods != p.methods) {
                if (this.methods.size() != p.methods.size()) {
                    return false;
                }
                for (int i = 0; i < this.methods.size(); ++i) {
                    if (this.methods.get(i) == p.methods.get(i)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class ABI {
        public List<Method> methods = null;
        public List<Event> events = null;

        private ABI() {
        }

        public boolean equals(ABI abi) {
            int i;
            if (this == abi) {
                return true;
            }
            if (this.methods != abi.methods) {
                if (this.methods.size() != abi.methods.size()) {
                    return false;
                }
                for (i = 0; i < this.methods.size(); ++i) {
                    if (this.methods.get(i).equals(abi.methods.get(i))) continue;
                    return false;
                }
            }
            if (this.events != abi.events) {
                if (this.events.size() != abi.events.size()) {
                    return false;
                }
                for (i = 0; i < this.events.size(); ++i) {
                    if (this.events.get(i).equals(abi.events.get(i))) continue;
                    return false;
                }
            }
            return true;
        }

        public static class Parameter {
            public String name = null;
            public byte type = 0;

            private Parameter() {
            }

            public boolean equals(Parameter p) {
                if (this == p) {
                    return true;
                }
                return this.name == p.name && this.type == p.type;
            }
        }

        public static class Event {
            public String name = null;
            public List<Parameter> parameters = null;

            private Event() {
            }

            public boolean equals(Event e) {
                if (this == e) {
                    return true;
                }
                if (this.name != e.name) {
                    return false;
                }
                if (this.parameters != e.parameters) {
                    if (this.parameters.size() != e.parameters.size()) {
                        return false;
                    }
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        if (this.parameters.get(i).equals(e.parameters.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }

        public static class Method {
            public String name = null;
            public List<Parameter> parameters = null;
            public Parameter returnType = null;
            public int offset = 0;
            public boolean safe = false;

            private Method() {
            }

            public boolean equals(Method m) {
                if (this == m) {
                    return true;
                }
                if (this.name != m.name || !this.returnType.equals(m.returnType) || this.offset != m.offset || this.safe != m.safe) {
                    return false;
                }
                if (this.parameters != m.parameters) {
                    if (this.parameters.size() != m.parameters.size()) {
                        return false;
                    }
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        if (this.parameters.get(i).equals(m.parameters.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
    }

    public static class Group {
        public ECPoint pubKey = null;
        public ByteString signature = null;

        private Group() {
        }

        public boolean equals(Group g) {
            if (this == g) {
                return true;
            }
            return this.pubKey == g.pubKey && this.signature == g.signature;
        }
    }
}

