/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.SmartContract;
import io.neow3j.contract.exceptions.UnexpectedReturnTypeException;
import io.neow3j.protocol.Neow3j;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Token
extends SmartContract {
    private static final String TOTAL_SUPPLY = "totalSupply";
    private static final String SYMBOL = "symbol";
    private static final String DECIMALS = "decimals";
    private BigInteger totalSupply;
    private Integer decimals;
    private String symbol;

    public Token(Hash160 scriptHash, Neow3j neow3j) {
        super(scriptHash, neow3j);
    }

    public String getSymbol() throws IOException, UnexpectedReturnTypeException {
        if (this.symbol == null) {
            this.symbol = this.callFuncReturningString(SYMBOL, new ContractParameter[0]);
        }
        return this.symbol;
    }

    public BigInteger getTotalSupply() throws IOException, UnexpectedReturnTypeException {
        if (this.totalSupply == null) {
            this.totalSupply = this.callFuncReturningInt(TOTAL_SUPPLY, new ContractParameter[0]);
        }
        return this.totalSupply;
    }

    public int getDecimals() throws IOException, UnexpectedReturnTypeException {
        if (this.decimals == null) {
            this.decimals = this.callFuncReturningInt(DECIMALS, new ContractParameter[0]).intValue();
        }
        return this.decimals;
    }

    public BigInteger toFractions(BigDecimal amount) throws IOException {
        return Token.toFractions(amount, this.getDecimals());
    }

    public static BigInteger toFractions(BigDecimal amount, int decimals) {
        if (amount.stripTrailingZeros().scale() > decimals) {
            throw new IllegalArgumentException("The provided amount has too many decimal points. Make sure the decimals of the provided amount do not exceed the supported token decimals.");
        }
        BigInteger factor = BigInteger.TEN.pow(decimals);
        BigDecimal fractions = amount.multiply(new BigDecimal(factor));
        return fractions.toBigInteger();
    }

    public BigDecimal toDecimals(BigInteger amount) throws IOException {
        return Token.toDecimals(amount, this.getDecimals());
    }

    public static BigDecimal toDecimals(BigInteger amount, int decimals) {
        return new BigDecimal(amount, decimals);
    }
}

