/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.exceptions.UnexpectedReturnTypeException;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.response.ContractManifest;
import io.neow3j.protocol.core.response.ContractState;
import io.neow3j.protocol.core.response.InvocationResult;
import io.neow3j.protocol.core.response.NeoGetContractState;
import io.neow3j.protocol.core.response.NeoInvokeFunction;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.protocol.exceptions.InvocationFaultStateException;
import io.neow3j.protocol.exceptions.StackItemCastException;
import io.neow3j.script.ScriptBuilder;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.Numeric;
import io.neow3j.utils.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SmartContract {
    protected Hash160 scriptHash;
    protected Neow3j neow3j;

    public SmartContract(Hash160 scriptHash, Neow3j neow3j) {
        if (scriptHash == null) {
            throw new IllegalArgumentException("The contract script hash must not be null.");
        }
        if (neow3j == null) {
            throw new IllegalArgumentException("The Neow3j object must not be null.");
        }
        this.scriptHash = scriptHash;
        this.neow3j = neow3j;
    }

    public TransactionBuilder invokeFunction(String function, ContractParameter ... params) {
        byte[] script = this.buildInvokeFunctionScript(function, params);
        return new TransactionBuilder(this.neow3j).script(script);
    }

    public byte[] buildInvokeFunctionScript(String function, ContractParameter ... params) {
        if (Strings.isEmpty((String)function)) {
            throw new IllegalArgumentException("The invocation function must not be null or empty.");
        }
        return new ScriptBuilder().contractCall(this.scriptHash, function, Arrays.asList(params)).toArray();
    }

    public String callFuncReturningString(String function, ContractParameter ... params) throws UnexpectedReturnTypeException, IOException {
        InvocationResult invocationResult = this.callInvokeFunction(function, Arrays.asList(params), new Signer[0]).getInvocationResult();
        this.throwIfFaultState(invocationResult);
        StackItem item = (StackItem)invocationResult.getStack().get(0);
        StackItemType type = item.getType();
        if (type.equals((Object)StackItemType.BYTE_STRING)) {
            return item.getString();
        }
        throw new UnexpectedReturnTypeException(type, StackItemType.BYTE_STRING);
    }

    public BigInteger callFuncReturningInt(String function, ContractParameter ... params) throws IOException, UnexpectedReturnTypeException {
        InvocationResult invocationResult = params.length == 0 ? this.callInvokeFunction(function, new Signer[0]).getInvocationResult() : this.callInvokeFunction(function, Arrays.asList(params), new Signer[0]).getInvocationResult();
        this.throwIfFaultState(invocationResult);
        StackItem item = (StackItem)invocationResult.getStack().get(0);
        if (item.getType().equals((Object)StackItemType.INTEGER)) {
            return item.getInteger();
        }
        throw new UnexpectedReturnTypeException(item.getType(), StackItemType.INTEGER);
    }

    public boolean callFuncReturningBool(String function, ContractParameter ... params) throws IOException, UnexpectedReturnTypeException {
        InvocationResult invocationResult = params.length == 0 ? this.callInvokeFunction(function, new Signer[0]).getInvocationResult() : this.callInvokeFunction(function, Arrays.asList(params), new Signer[0]).getInvocationResult();
        this.throwIfFaultState(invocationResult);
        StackItem item = (StackItem)invocationResult.getStack().get(0);
        StackItemType type = item.getType();
        if (type.equals((Object)StackItemType.BOOLEAN) || type.equals((Object)StackItemType.INTEGER) || type.equals((Object)StackItemType.BYTE_STRING) || type.equals((Object)StackItemType.BUFFER)) {
            return item.getBoolean();
        }
        throw new UnexpectedReturnTypeException(type, StackItemType.BOOLEAN);
    }

    public Hash160 callFunctionReturningScriptHash(String function, ContractParameter ... params) throws IOException {
        InvocationResult result = this.callInvokeFunction(function, Arrays.asList(params), new Signer[0]).getInvocationResult();
        this.throwIfFaultState(result);
        StackItem stackItem = (StackItem)result.getStack().get(0);
        return this.extractScriptHash(stackItem);
    }

    private Hash160 extractScriptHash(StackItem item) {
        if (!item.getType().equals((Object)StackItemType.BYTE_STRING)) {
            throw new UnexpectedReturnTypeException(item.getType(), StackItemType.BYTE_STRING);
        }
        try {
            return new Hash160(Numeric.reverseHexString((String)item.getHexString()));
        }
        catch (StackItemCastException | IllegalArgumentException e) {
            throw new UnexpectedReturnTypeException("Return type did not contain script hash in expected format.", (Exception)e);
        }
    }

    public List<StackItem> callFunctionReturningIterator(String function, ContractParameter ... params) throws IOException {
        InvocationResult invocationResult = this.callInvokeFunction(function, Arrays.asList(params), new Signer[0]).getInvocationResult();
        this.throwIfFaultState(invocationResult);
        StackItem stackItem = (StackItem)invocationResult.getStack().get(0);
        if (!stackItem.getType().equals((Object)StackItemType.INTEROP_INTERFACE)) {
            throw new UnexpectedReturnTypeException(stackItem.getType(), StackItemType.INTEROP_INTERFACE);
        }
        try {
            return stackItem.getIterator();
        }
        catch (StackItemCastException e) {
            throw new UnexpectedReturnTypeException("Return did not contain an iterator.", (Exception)((Object)e));
        }
    }

    public NeoInvokeFunction callInvokeFunction(String function, Signer ... signers) throws IOException {
        return this.callInvokeFunction(function, new ArrayList<ContractParameter>(), signers);
    }

    public NeoInvokeFunction callInvokeFunction(String function, List<ContractParameter> params, Signer ... signers) throws IOException {
        if (Strings.isEmpty((String)function)) {
            throw new IllegalArgumentException("The invocation function must not be null or empty.");
        }
        return (NeoInvokeFunction)this.neow3j.invokeFunction(this.scriptHash, function, params, signers).send();
    }

    void throwIfFaultState(InvocationResult invocationResult) {
        if (invocationResult.hasStateFault()) {
            throw new InvocationFaultStateException(invocationResult.getException());
        }
    }

    public Hash160 getScriptHash() {
        return this.scriptHash;
    }

    public ContractManifest getManifest() throws IOException {
        ContractState contractState = ((NeoGetContractState)this.neow3j.getContractState(this.scriptHash).send()).getContractState();
        return contractState.getManifest();
    }

    public String getName() throws IOException {
        return this.getManifest().getName();
    }

    protected static Hash160 calcNativeContractHash(String contractName) {
        return SmartContract.calcContractHash(Hash160.ZERO, 0L, contractName);
    }

    public static Hash160 calcContractHash(Hash160 sender, long nefCheckSum, String contractName) {
        return Hash160.fromScript((byte[])ScriptBuilder.buildContractHashScript((Hash160)sender, (long)nefCheckSum, (String)contractName));
    }
}

