/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.SmartContract;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.Role;
import io.neow3j.protocol.core.response.NeoBlockCount;
import io.neow3j.protocol.core.response.NeoInvokeFunction;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RoleManagement
extends SmartContract {
    private static final String NAME = "RoleManagement";
    public static final Hash160 SCRIPT_HASH = RoleManagement.calcNativeContractHash("RoleManagement");
    private static final String GET_DESIGNATED_BY_ROLE = "getDesignatedByRole";
    private static final String DESIGNATE_AS_ROLE = "designateAsRole";

    public RoleManagement(Neow3j neow) {
        super(SCRIPT_HASH, neow);
    }

    public List<ECKeyPair.ECPublicKey> getDesignatedByRole(Role role, BigInteger blockIndex) throws IOException {
        this.checkBlockIndexValidity(blockIndex);
        NeoInvokeFunction invocation = this.callInvokeFunction(GET_DESIGNATED_BY_ROLE, Arrays.asList(ContractParameter.integer((byte)role.byteValue()), ContractParameter.integer((BigInteger)blockIndex)), new Signer[0]);
        List arrayOfDesignates = ((StackItem)invocation.getInvocationResult().getStack().get(0)).getList();
        return arrayOfDesignates.stream().map(item -> new ECKeyPair.ECPublicKey(item.getByteArray())).collect(Collectors.toList());
    }

    private void checkBlockIndexValidity(BigInteger blockIndex) throws IOException {
        if (blockIndex.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("The block index has to be positive.");
        }
        BigInteger currentBlockCount = ((NeoBlockCount)this.neow3j.getBlockCount().send()).getBlockCount();
        if (blockIndex.compareTo(currentBlockCount) > 0) {
            throw new IllegalArgumentException("The provided block index (" + blockIndex + ") is too high. The current block count is " + currentBlockCount + ".");
        }
    }

    public TransactionBuilder designateAsRole(Role role, List<ECKeyPair.ECPublicKey> pubKeys) {
        if (role == null) {
            throw new IllegalArgumentException("The designation role cannot be null.");
        }
        if (pubKeys == null || pubKeys.isEmpty()) {
            throw new IllegalArgumentException("At least one public key is required for designation.");
        }
        ContractParameter roleParam = ContractParameter.integer((byte)role.byteValue());
        List pubKeysParams = pubKeys.stream().map(k -> ContractParameter.publicKey((byte[])k.getEncoded(true))).collect(Collectors.toList());
        return this.invokeFunction(DESIGNATE_AS_ROLE, roleParam, ContractParameter.array(pubKeysParams));
    }
}

