/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.SmartContract;
import io.neow3j.protocol.Neow3j;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import java.io.IOException;
import java.math.BigInteger;

public class PolicyContract
extends SmartContract {
    private static final String NAME = "PolicyContract";
    public static final Hash160 SCRIPT_HASH = PolicyContract.calcNativeContractHash("PolicyContract");
    private static final String GET_FEE_PER_BYTE = "getFeePerByte";
    private static final String GET_EXEC_FEE_FACTOR = "getExecFeeFactor";
    private static final String GET_STORAGE_PRICE = "getStoragePrice";
    private static final String IS_BLOCKED = "isBlocked";
    private static final String SET_FEE_PER_BYTE = "setFeePerByte";
    private static final String SET_EXEC_FEE_FACTOR = "setExecFeeFactor";
    private static final String SET_STORAGE_PRICE = "setStoragePrice";
    private static final String BLOCK_ACCOUNT = "blockAccount";
    private static final String UNBLOCK_ACCOUNT = "unblockAccount";

    public PolicyContract(Neow3j neow) {
        super(SCRIPT_HASH, neow);
    }

    public BigInteger getFeePerByte() throws IOException {
        return this.callFuncReturningInt(GET_FEE_PER_BYTE, new ContractParameter[0]);
    }

    public BigInteger getExecFeeFactor() throws IOException {
        return this.callFuncReturningInt(GET_EXEC_FEE_FACTOR, new ContractParameter[0]);
    }

    public BigInteger getStoragePrice() throws IOException {
        return this.callFuncReturningInt(GET_STORAGE_PRICE, new ContractParameter[0]);
    }

    public boolean isBlocked(Hash160 scriptHash) throws IOException {
        return this.callFuncReturningBool(IS_BLOCKED, ContractParameter.hash160((Hash160)scriptHash));
    }

    public TransactionBuilder setFeePerByte(BigInteger fee) {
        return this.invokeFunction(SET_FEE_PER_BYTE, ContractParameter.integer((BigInteger)fee));
    }

    public TransactionBuilder setExecFeeFactor(BigInteger fee) {
        return this.invokeFunction(SET_EXEC_FEE_FACTOR, ContractParameter.integer((BigInteger)fee));
    }

    public TransactionBuilder setStoragePrice(BigInteger price) {
        return this.invokeFunction(SET_STORAGE_PRICE, ContractParameter.integer((BigInteger)price));
    }

    public TransactionBuilder blockAccount(String addressToBlock) {
        return this.invokeFunction(BLOCK_ACCOUNT, ContractParameter.hash160((Hash160)Hash160.fromAddress((String)addressToBlock)));
    }

    public TransactionBuilder blockAccount(Hash160 accountToBlock) {
        return this.invokeFunction(BLOCK_ACCOUNT, ContractParameter.hash160((Hash160)accountToBlock));
    }

    public TransactionBuilder unblockAccount(String addressToBlock) {
        return this.invokeFunction(UNBLOCK_ACCOUNT, ContractParameter.hash160((Hash160)Hash160.fromAddress((String)addressToBlock)));
    }

    public TransactionBuilder unblockAccount(Hash160 accountToUnblock) {
        return this.invokeFunction(UNBLOCK_ACCOUNT, ContractParameter.hash160((Hash160)accountToUnblock));
    }
}

