/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.Token;
import io.neow3j.contract.exceptions.UnexpectedReturnTypeException;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.transaction.AccountSigner;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import io.neow3j.types.StackItemType;
import io.neow3j.wallet.Account;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NonFungibleToken
extends Token {
    private static final String OWNER_OF = "ownerOf";
    private static final String TOKENS_OF = "tokensOf";
    private static final String BALANCE_OF = "balanceOf";
    private static final String TRANSFER = "transfer";
    private static final String TOKENS = "tokens";
    private static final String PROPERTIES = "properties";

    public NonFungibleToken(Hash160 scriptHash, Neow3j neow) {
        super(scriptHash, neow);
    }

    public BigInteger balanceOf(Hash160 owner) throws IOException {
        return this.callFuncReturningInt(BALANCE_OF, ContractParameter.hash160((Hash160)owner));
    }

    public List<byte[]> tokensOf(Hash160 owner) throws IOException {
        return this.callFunctionReturningIterator(TOKENS_OF, ContractParameter.hash160((Hash160)owner)).stream().map(StackItem::getByteArray).collect(Collectors.toList());
    }

    public TransactionBuilder transfer(Account from, Hash160 to, byte[] tokenId) throws IOException {
        return this.transfer(from, to, tokenId, null);
    }

    public TransactionBuilder transfer(Account from, Hash160 to, byte[] tokenId, ContractParameter data) throws IOException {
        this.throwIfSenderIsNotOwner(from.getScriptHash(), tokenId);
        return this.transfer(to, tokenId, data).signers(new Signer[]{AccountSigner.calledByEntry((Account)from)});
    }

    public TransactionBuilder transfer(Hash160 to, byte[] tokenId) throws IOException {
        return this.transfer(to, tokenId, null);
    }

    public TransactionBuilder transfer(Hash160 to, byte[] tokenId, ContractParameter data) throws IOException {
        this.throwIfDivisibleNFT();
        return this.invokeFunction(TRANSFER, ContractParameter.hash160((Hash160)to), ContractParameter.byteArray((byte[])tokenId), data);
    }

    public byte[] buildNonDivisibleTransferScript(Hash160 to, byte[] tokenId, ContractParameter data) throws IOException {
        this.throwIfDivisibleNFT();
        return this.buildInvokeFunctionScript(TRANSFER, ContractParameter.hash160((Hash160)to), ContractParameter.byteArray((byte[])tokenId), data);
    }

    public Hash160 ownerOf(byte[] tokenId) throws IOException {
        this.throwIfDivisibleNFT();
        return this.callFunctionReturningScriptHash(OWNER_OF, ContractParameter.byteArray((byte[])tokenId));
    }

    private void throwIfDivisibleNFT() throws IOException {
        if (this.getDecimals() != 0) {
            throw new IllegalStateException("This method is only intended for non-divisible NFTs.");
        }
    }

    private void throwIfSenderIsNotOwner(Hash160 from, byte[] tokenId) throws IOException {
        Hash160 tokenOwner = this.ownerOf(tokenId);
        if (!tokenOwner.equals((Object)from)) {
            throw new IllegalArgumentException("The provided from account is not the owner of this token.");
        }
    }

    public TransactionBuilder transfer(Account from, Hash160 to, BigInteger amount, byte[] tokenID) throws IOException {
        return this.transfer(from, to, amount, tokenID, null);
    }

    public TransactionBuilder transfer(Account from, Hash160 to, BigInteger amount, byte[] tokenId, ContractParameter data) throws IOException {
        return this.transfer(from.getScriptHash(), to, amount, tokenId, data).signers(new Signer[]{AccountSigner.calledByEntry((Account)from)});
    }

    public TransactionBuilder transfer(Hash160 from, Hash160 to, BigInteger amount, byte[] tokenID) throws IOException {
        return this.transfer(from, to, amount, tokenID, null);
    }

    public TransactionBuilder transfer(Hash160 from, Hash160 to, BigInteger amount, byte[] tokenId, ContractParameter data) throws IOException {
        this.throwIfNonDivisibleNFT();
        return this.invokeFunction(TRANSFER, ContractParameter.hash160((Hash160)from), ContractParameter.hash160((Hash160)to), ContractParameter.integer((BigInteger)amount), ContractParameter.byteArray((byte[])tokenId), data);
    }

    public byte[] buildDivisibleTransferScript(Hash160 from, Hash160 to, BigInteger amount, byte[] tokenId, ContractParameter data) throws IOException {
        this.throwIfNonDivisibleNFT();
        return this.buildInvokeFunctionScript(TRANSFER, ContractParameter.hash160((Hash160)from), ContractParameter.hash160((Hash160)to), ContractParameter.integer((BigInteger)amount), ContractParameter.byteArray((byte[])tokenId), data);
    }

    public List<Hash160> ownersOf(byte[] tokenId) throws IOException {
        this.throwIfNonDivisibleNFT();
        return this.callFunctionReturningIterator(OWNER_OF, ContractParameter.byteArray((byte[])tokenId)).stream().map(StackItem::getAddress).map(Hash160::fromAddress).collect(Collectors.toList());
    }

    private void throwIfNonDivisibleNFT() throws IOException {
        if (this.getDecimals() == 0) {
            throw new IllegalStateException("This method is only intended for divisible NFTs.");
        }
    }

    public BigInteger balanceOf(Hash160 owner, byte[] tokenId) throws IOException {
        this.throwIfNonDivisibleNFT();
        return this.callFuncReturningInt(BALANCE_OF, ContractParameter.hash160((Hash160)owner), ContractParameter.byteArray((byte[])tokenId));
    }

    public List<byte[]> tokens() throws IOException {
        return this.callFunctionReturningIterator(TOKENS, new ContractParameter[0]).stream().map(StackItem::getByteArray).collect(Collectors.toList());
    }

    public Map<String, String> properties(byte[] tokenId) throws IOException {
        StackItem item = (StackItem)this.callInvokeFunction(PROPERTIES, Collections.singletonList(ContractParameter.byteArray((byte[])tokenId)), new Signer[0]).getInvocationResult().getStack().get(0);
        if (item.getType().equals((Object)StackItemType.MAP)) {
            return item.getMap().entrySet().stream().collect(Collectors.toMap(e -> ((StackItem)e.getKey()).getString(), e -> ((StackItem)e.getValue()).getString()));
        }
        throw new UnexpectedReturnTypeException(item.getType(), StackItemType.MAP);
    }

    public Map<String, StackItem> customProperties(byte[] tokenId) throws IOException {
        StackItem item = (StackItem)this.callInvokeFunction(PROPERTIES, Arrays.asList(ContractParameter.byteArray((byte[])tokenId)), new Signer[0]).getInvocationResult().getStack().get(0);
        if (item.getType().equals((Object)StackItemType.MAP)) {
            return item.getMap().entrySet().stream().collect(Collectors.toMap(e -> ((StackItem)e.getKey()).getString(), Map.Entry::getValue));
        }
        throw new UnexpectedReturnTypeException(item.getType(), StackItemType.MAP);
    }
}

