/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.FungibleToken;
import io.neow3j.contract.GasToken;
import io.neow3j.contract.NeoToken;
import io.neow3j.protocol.Neow3j;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.Hash160;
import io.neow3j.utils.Strings;
import io.neow3j.wallet.Account;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.IllegalFormatException;

public class NeoURI {
    private URI uri;
    private Neow3j neow3j;
    private Hash160 recipient;
    private Hash160 tokenHash;
    private BigDecimal amount;
    private static final String NEO_SCHEME = "neo";
    private static final int MIN_NEP9_URI_LENGTH = 38;
    private static final String NEO_TOKEN_STRING = "neo";
    private static final String GAS_TOKEN_STRING = "gas";

    public NeoURI() {
    }

    public NeoURI(Neow3j neow3j) {
        this.neow3j = neow3j;
    }

    public static NeoURI fromURI(String uriString) throws IllegalFormatException {
        if (uriString == null) {
            throw new IllegalArgumentException("The provided String is null.");
        }
        String[] baseAndQuery = uriString.split("\\?");
        String[] beginTx = baseAndQuery[0].split(":");
        if (!beginTx[0].equals("neo") || beginTx.length != 2 || uriString.length() < 38) {
            throw new IllegalArgumentException("The provided string does not conform to the NEP-9 standard.");
        }
        NeoURI neoURI = new NeoURI();
        neoURI.to(Hash160.fromAddress((String)beginTx[1]));
        if (baseAndQuery.length == 2) {
            String[] query;
            for (String singleQuery : query = baseAndQuery[1].split("&")) {
                String[] singleQueryParts = singleQuery.split("=");
                if (singleQueryParts.length != 2) {
                    throw new IllegalArgumentException("This uri contains invalid queries.");
                }
                if (singleQueryParts[0].equals("asset") && neoURI.tokenHash == null) {
                    String assetID = singleQueryParts[1];
                    if (assetID.equals("neo")) {
                        neoURI.tokenHash = NeoToken.SCRIPT_HASH;
                        continue;
                    }
                    if (assetID.equals(GAS_TOKEN_STRING)) {
                        neoURI.tokenHash = GasToken.SCRIPT_HASH;
                        continue;
                    }
                    neoURI.tokenHash = new Hash160(assetID);
                    continue;
                }
                if (!singleQueryParts[0].equals("amount") || neoURI.amount != null) continue;
                neoURI.amount = new BigDecimal(singleQueryParts[1]);
            }
        }
        return neoURI;
    }

    public TransactionBuilder buildTransferFrom(Account sender) throws IOException {
        if (this.neow3j == null) {
            throw new IllegalStateException("Neow3j instance is not set.");
        }
        if (this.recipient == null) {
            throw new IllegalStateException("Recipient is not set.");
        }
        if (this.amount == null) {
            throw new IllegalStateException("Amount is not set.");
        }
        FungibleToken token = new FungibleToken(this.tokenHash, this.neow3j);
        int amountScale = this.amount.stripTrailingZeros().scale();
        if (this.isNeoToken(this.tokenHash) && amountScale > 0) {
            throw new IllegalArgumentException("The Neo token does not support any decimal places.");
        }
        if (this.isGasToken(this.tokenHash) && amountScale > 8) {
            throw new IllegalArgumentException("The Gas token does not support more than 8 decimal places.");
        }
        int decimals = token.getDecimals();
        if (amountScale > decimals) {
            throw new IllegalArgumentException("The token '" + this.tokenHash + "' does not support more than " + decimals + " decimal places.");
        }
        return token.transfer(sender, this.recipient, token.toFractions(this.amount));
    }

    private boolean isNeoToken(Hash160 asset) {
        return asset.equals((Object)NeoToken.SCRIPT_HASH);
    }

    private boolean isGasToken(Hash160 asset) {
        return asset.equals((Object)GasToken.SCRIPT_HASH);
    }

    public NeoURI to(Hash160 recipient) {
        this.recipient = recipient;
        return this;
    }

    public NeoURI token(Hash160 token) {
        this.tokenHash = token;
        return this;
    }

    public NeoURI token(String token) {
        this.tokenHash = token.equals("neo") ? NeoToken.SCRIPT_HASH : (token.equals(GAS_TOKEN_STRING) ? GasToken.SCRIPT_HASH : new Hash160(token));
        return this;
    }

    public NeoURI amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public NeoURI neow3j(Neow3j neow3j) {
        this.neow3j = neow3j;
        return this;
    }

    private String buildQueryPart() {
        ArrayList<String> query = new ArrayList<String>();
        if (this.tokenHash != null) {
            if (this.tokenHash.equals((Object)NeoToken.SCRIPT_HASH)) {
                query.add("asset=neo");
            } else if (this.tokenHash.equals((Object)GasToken.SCRIPT_HASH)) {
                query.add("asset=gas");
            } else {
                query.add("asset=" + this.tokenHash);
            }
        }
        if (this.amount != null) {
            query.add("amount=" + this.amount);
        }
        return Strings.join(query, (String)"&");
    }

    public NeoURI buildURI() {
        if (this.recipient == null) {
            throw new IllegalStateException("Could not create a NEP-9 URI without a recipient address.");
        }
        String basePart = "neo:" + this.recipient.toAddress();
        String queryPart = this.buildQueryPart();
        String uri = queryPart.equals("") ? basePart : basePart + "?" + queryPart;
        this.uri = URI.create(uri);
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getURIAsString() {
        return this.uri.toString();
    }

    public Hash160 getRecipient() {
        return this.recipient;
    }

    public String getRecipientAddress() {
        return this.recipient.toAddress();
    }

    public Hash160 getToken() {
        return this.tokenHash;
    }

    public String getTokenAsString() {
        if (this.tokenHash.equals((Object)NeoToken.SCRIPT_HASH)) {
            return "neo";
        }
        if (this.tokenHash.equals((Object)GasToken.SCRIPT_HASH)) {
            return GAS_TOKEN_STRING;
        }
        return this.tokenHash.toString();
    }

    public String getTokenAsAddress() {
        return this.tokenHash.toAddress();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getAmountAsString() {
        return this.amount.toString();
    }
}

