/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.FungibleToken;
import io.neow3j.contract.exceptions.UnexpectedReturnTypeException;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.response.NeoAccountState;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import io.neow3j.types.StackItemType;
import io.neow3j.wallet.Account;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NeoToken
extends FungibleToken {
    public static final String NAME = "NeoToken";
    public static final Hash160 SCRIPT_HASH = NeoToken.calcNativeContractHash("NeoToken");
    public static final int DECIMALS = 0;
    public static final String SYMBOL = "NEO";
    public static final BigInteger TOTAL_SUPPLY = new BigInteger("100000000");
    private static final String UNCLAIMED_GAS = "unclaimedGas";
    private static final String REGISTER_CANDIDATE = "registerCandidate";
    private static final String UNREGISTER_CANDIDATE = "unregisterCandidate";
    private static final String VOTE = "vote";
    private static final String GET_CANDIDATES = "getCandidates";
    private static final String GET_COMMITTEE = "getCommittee";
    private static final String GET_NEXT_BLOCK_VALIDATORS = "getNextBlockValidators";
    private static final String SET_GAS_PER_BLOCK = "setGasPerBlock";
    private static final String GET_GAS_PER_BLOCK = "getGasPerBlock";
    private static final String SET_REGISTER_PRICE = "setRegisterPrice";
    private static final String GET_REGISTER_PRICE = "getRegisterPrice";
    private static final String GET_ACCOUNT_STATE = "getAccountState";

    public NeoToken(Neow3j neow) {
        super(SCRIPT_HASH, neow);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSymbol() {
        return SYMBOL;
    }

    @Override
    public BigInteger getTotalSupply() {
        return TOTAL_SUPPLY;
    }

    @Override
    public int getDecimals() {
        return 0;
    }

    public BigInteger unclaimedGas(Account account, long blockHeight) throws IOException {
        return this.unclaimedGas(account.getScriptHash(), blockHeight);
    }

    public BigInteger unclaimedGas(Hash160 scriptHash, long blockHeight) throws IOException {
        ContractParameter accParam = ContractParameter.hash160((Hash160)scriptHash);
        ContractParameter heightParam = ContractParameter.integer((BigInteger)BigInteger.valueOf(blockHeight));
        return this.callFuncReturningInt(UNCLAIMED_GAS, accParam, heightParam);
    }

    public TransactionBuilder registerCandidate(ECKeyPair.ECPublicKey candidateKey) {
        return this.invokeFunction(REGISTER_CANDIDATE, ContractParameter.publicKey((byte[])candidateKey.getEncoded(true)));
    }

    public TransactionBuilder unregisterCandidate(ECKeyPair.ECPublicKey candidateKey) {
        return this.invokeFunction(UNREGISTER_CANDIDATE, ContractParameter.publicKey((byte[])candidateKey.getEncoded(true)));
    }

    public List<ECKeyPair.ECPublicKey> getCommittee() throws IOException {
        return this.callFunctionReturningListOfPublicKeys(GET_COMMITTEE);
    }

    public Map<ECKeyPair.ECPublicKey, BigInteger> getCandidates() throws IOException {
        StackItem arrayItem = (StackItem)this.callInvokeFunction(GET_CANDIDATES, new Signer[0]).getInvocationResult().getStack().get(0);
        if (!arrayItem.getType().equals((Object)StackItemType.ARRAY)) {
            throw new UnexpectedReturnTypeException(arrayItem.getType(), StackItemType.ARRAY);
        }
        HashMap<ECKeyPair.ECPublicKey, BigInteger> validators = new HashMap<ECKeyPair.ECPublicKey, BigInteger>();
        for (StackItem valItem : arrayItem.getList()) {
            if (!valItem.getType().equals((Object)StackItemType.STRUCT)) {
                throw new UnexpectedReturnTypeException(valItem.getType(), StackItemType.STRUCT);
            }
            ECKeyPair.ECPublicKey key = this.extractPublicKey((StackItem)valItem.getList().get(0));
            StackItem nrItem = (StackItem)valItem.getList().get(1);
            if (!nrItem.getType().equals((Object)StackItemType.INTEGER)) {
                throw new UnexpectedReturnTypeException(nrItem.getType(), StackItemType.INTEGER);
            }
            validators.put(key, nrItem.getInteger());
        }
        return validators;
    }

    public boolean isCandidate(ECKeyPair.ECPublicKey publicKey) throws IOException {
        return this.getCandidates().containsKey(publicKey);
    }

    public List<ECKeyPair.ECPublicKey> getNextBlockValidators() throws IOException {
        return this.callFunctionReturningListOfPublicKeys(GET_NEXT_BLOCK_VALIDATORS);
    }

    private List<ECKeyPair.ECPublicKey> callFunctionReturningListOfPublicKeys(String function) throws IOException {
        StackItem arrayItem = (StackItem)this.callInvokeFunction(function, new Signer[0]).getInvocationResult().getStack().get(0);
        if (!arrayItem.getType().equals((Object)StackItemType.ARRAY)) {
            throw new UnexpectedReturnTypeException(arrayItem.getType(), StackItemType.ARRAY);
        }
        ArrayList<ECKeyPair.ECPublicKey> valKeys = new ArrayList<ECKeyPair.ECPublicKey>();
        for (StackItem keyItem : arrayItem.getList()) {
            valKeys.add(this.extractPublicKey(keyItem));
        }
        return valKeys;
    }

    private ECKeyPair.ECPublicKey extractPublicKey(StackItem keyItem) {
        if (!keyItem.getType().equals((Object)StackItemType.BYTE_STRING)) {
            throw new UnexpectedReturnTypeException(keyItem.getType(), StackItemType.BYTE_STRING);
        }
        try {
            return new ECKeyPair.ECPublicKey(keyItem.getByteArray());
        }
        catch (IllegalArgumentException e) {
            throw new UnexpectedReturnTypeException("Byte array return type did not contain public key in expected format.", e);
        }
    }

    public TransactionBuilder vote(Account voter, ECKeyPair.ECPublicKey candidate) throws IOException {
        return this.vote(voter.getScriptHash(), candidate);
    }

    public TransactionBuilder vote(Hash160 voter, ECKeyPair.ECPublicKey candidate) throws IOException {
        if (candidate == null) {
            return this.invokeFunction(VOTE, ContractParameter.hash160((Hash160)voter), ContractParameter.any(null));
        }
        return this.invokeFunction(VOTE, ContractParameter.hash160((Hash160)voter), ContractParameter.publicKey((byte[])candidate.getEncoded(true)));
    }

    public TransactionBuilder cancelVote(Hash160 voter) throws IOException {
        return this.vote(voter, null);
    }

    public TransactionBuilder cancelVote(Account voter) throws IOException {
        return this.cancelVote(voter.getScriptHash());
    }

    public byte[] buildVoteScript(Hash160 voter, ECKeyPair.ECPublicKey candidate) {
        if (candidate == null) {
            return this.buildInvokeFunctionScript(VOTE, ContractParameter.hash160((Hash160)voter), ContractParameter.any(null));
        }
        return this.buildInvokeFunctionScript(VOTE, ContractParameter.hash160((Hash160)voter), ContractParameter.publicKey((byte[])candidate.getEncoded(true)));
    }

    public BigInteger getGasPerBlock() throws IOException {
        return this.callFuncReturningInt(GET_GAS_PER_BLOCK, new ContractParameter[0]);
    }

    public TransactionBuilder setGasPerBlock(BigInteger gasPerBlock) {
        return this.invokeFunction(SET_GAS_PER_BLOCK, ContractParameter.integer((BigInteger)gasPerBlock));
    }

    public BigInteger getRegisterPrice() throws IOException {
        return this.callFuncReturningInt(GET_REGISTER_PRICE, new ContractParameter[0]);
    }

    public TransactionBuilder setRegisterPrice(BigInteger registerPrice) {
        return this.invokeFunction(SET_REGISTER_PRICE, ContractParameter.integer((BigInteger)registerPrice));
    }

    public NeoAccountState getAccountState(Hash160 account) throws IOException {
        StackItem result = (StackItem)this.callInvokeFunction(GET_ACCOUNT_STATE, Arrays.asList(ContractParameter.hash160((Hash160)account)), new Signer[0]).getInvocationResult().getStack().get(0);
        if (result.getType().equals((Object)StackItemType.ANY)) {
            return NeoAccountState.withNoBalance();
        }
        List state = result.getList();
        BigInteger balance = ((StackItem)state.get(0)).getInteger();
        BigInteger updateHeight = ((StackItem)state.get(1)).getInteger();
        StackItem publicKeyItem = (StackItem)state.get(2);
        if (publicKeyItem.getType().equals((Object)StackItemType.ANY)) {
            return NeoAccountState.withNoVote((BigInteger)balance, (BigInteger)updateHeight);
        }
        return new NeoAccountState(balance, updateHeight, new ECKeyPair.ECPublicKey(publicKeyItem.getHexString()));
    }
}

