/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.NonFungibleToken;
import io.neow3j.contract.exceptions.UnexpectedReturnTypeException;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.RecordType;
import io.neow3j.protocol.core.response.InvocationResult;
import io.neow3j.protocol.core.response.NameState;
import io.neow3j.protocol.core.stackitem.ByteStringStackItem;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.protocol.exceptions.InvocationFaultStateException;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import io.neow3j.types.StackItemType;
import io.neow3j.wallet.Account;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class NeoNameService
extends NonFungibleToken {
    public static final String NAME = "NameService";
    private static final String ADD_ROOT = "addRoot";
    private static final String SET_PRICE = "setPrice";
    private static final String GET_PRICE = "getPrice";
    private static final String IS_AVAILABLE = "isAvailable";
    private static final String REGISTER = "register";
    private static final String RENEW = "renew";
    private static final String SET_ADMIN = "setAdmin";
    private static final String SET_RECORD = "setRecord";
    private static final String GET_RECORD = "getRecord";
    private static final String DELETE_RECORD = "deleteRecord";
    private static final String RESOLVE = "resolve";
    private static final ByteStringStackItem NAME_PROPERTY = new ByteStringStackItem("name".getBytes(StandardCharsets.UTF_8));
    private static final ByteStringStackItem EXPIRATION_PROPERTY = new ByteStringStackItem("expiration".getBytes(StandardCharsets.UTF_8));
    private static final ByteStringStackItem ADMIN_PROPERTY = new ByteStringStackItem("admin".getBytes(StandardCharsets.UTF_8));
    private static final String PROPERTIES = "properties";
    private static final BigInteger MAXIMAL_PRICE = BigInteger.valueOf(1000000000000L);
    private static final Pattern ROOT_REGEX_PATTERN = Pattern.compile("^[a-z][a-z0-9]{0,15}$");
    private static final Pattern NAME_REGEX_PATTERN = Pattern.compile("^(?=.{3,255}$)([a-z0-9]{1,62}\\.)+[a-z][a-z0-9]{0,15}$");
    private static final Pattern IPV4_REGEX_PATTERN = Pattern.compile("^(?=\\d+\\.\\d+\\.\\d+\\.\\d+$)(?:(?:25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\\.?){4}$");
    private static final Pattern IPV6_REGEX_PATTERN = Pattern.compile("(?:^)(([0-9a-f]{1,4}:){7,7}[0-9a-f]{1,4}|([0-9a-f]{1,4}:){1,7}:|([0-9a-f]{1,4}:){1,6}:[0-9a-f]{1,4}|([0-9a-f]{1,4}:){1,5}(:[0-9a-f]{1,4}){1,2}|([0-9a-f]{1,4}:){1,4}(:[0-9a-f]{1,4}){1,3}|([0-9a-f]{1,4}:){1,3}(:[0-9a-f]{1,4}){1,4}|([0-9a-f]{1,4}:){1,2}(:[0-9a-f]{1,4}){1,5}|[0-9a-f]{1,4}:((:[0-9a-f]{1,4}){1,6})|:((:[0-9a-f]{1,4}){1,7}|:))(?=$)");

    public NeoNameService(Hash160 scriptHash, Neow3j neow) {
        super(scriptHash, neow);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public TransactionBuilder addRoot(String root) {
        this.checkRegexMatch(ROOT_REGEX_PATTERN, root);
        return this.invokeFunction(ADD_ROOT, ContractParameter.string((String)root));
    }

    public TransactionBuilder setPrice(List<BigInteger> priceList) {
        Optional<BigInteger> bigIntegerStream = priceList.stream().filter(p -> !this.isValidPrice((BigInteger)p)).findFirst();
        if (bigIntegerStream.isPresent()) {
            throw new IllegalArgumentException("The prices need to be greater than 0 and smaller than 10000_00000000.");
        }
        ContractParameter priceListParameter = ContractParameter.array(priceList);
        return this.invokeFunction(SET_PRICE, priceListParameter);
    }

    private boolean isValidPrice(BigInteger price) {
        return price.compareTo(BigInteger.ZERO) > 0 && price.compareTo(MAXIMAL_PRICE) <= 0;
    }

    public BigInteger getPrice(int domainNameLength) throws IOException {
        return this.callFuncReturningInt(GET_PRICE, ContractParameter.integer((int)domainNameLength));
    }

    public boolean isAvailable(String name) throws IOException {
        this.checkDomainNameValidity(name);
        return this.callFuncReturningBool(IS_AVAILABLE, ContractParameter.string((String)name));
    }

    public TransactionBuilder register(String name, Hash160 owner) throws IOException {
        this.checkDomainNameAvailability(name, true);
        return this.invokeFunction(REGISTER, ContractParameter.string((String)name), ContractParameter.hash160((Hash160)owner));
    }

    void checkDomainNameAvailability(String name, boolean shouldBeAvailable) throws IOException {
        boolean isAvailable = this.isAvailable(name);
        if (shouldBeAvailable && !isAvailable) {
            throw new IllegalArgumentException("The domain name '" + name + "' is already taken.");
        }
        if (!shouldBeAvailable && isAvailable) {
            throw new IllegalArgumentException("The domain name '" + name + "' is not registered.");
        }
    }

    private void checkDomainNameValidity(String name) {
        this.checkRegexMatch(NAME_REGEX_PATTERN, name);
        if (name.split("\\.").length != 2) {
            throw new IllegalArgumentException("Only second-level domain names are allowed to be registered.");
        }
    }

    private void checkRegexMatch(Pattern pattern, String input) {
        if (!pattern.matcher(input).matches()) {
            throw new IllegalArgumentException("The provided input does not match the required regex.");
        }
    }

    public TransactionBuilder renew(String name) throws IOException {
        this.checkDomainNameAvailability(name, false);
        return this.invokeFunction(RENEW, ContractParameter.string((String)name));
    }

    public TransactionBuilder setAdmin(String name, Hash160 admin) throws IOException {
        this.checkDomainNameAvailability(name, false);
        return this.invokeFunction(SET_ADMIN, ContractParameter.string((String)name), ContractParameter.hash160((Hash160)admin));
    }

    public TransactionBuilder setRecord(String name, RecordType type, String data) throws IOException {
        this.checkDomainNameAvailability(name, false);
        this.checkDataMatchingRecordType(type, data);
        return this.invokeFunction(SET_RECORD, ContractParameter.string((String)name), ContractParameter.integer((byte)type.byteValue()), ContractParameter.string((String)data));
    }

    private void checkDataMatchingRecordType(RecordType type, String data) {
        if (type.equals((Object)RecordType.A)) {
            this.checkRegexMatch(IPV4_REGEX_PATTERN, data);
        } else if (type.equals((Object)RecordType.CNAME)) {
            this.checkRegexMatch(NAME_REGEX_PATTERN, data);
        } else if (type.equals((Object)RecordType.TXT)) {
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            if (bytes.length > 255) {
                throw new IllegalArgumentException("The provided data is not valid for the record type TXT.");
            }
        } else {
            this.checkRegexMatch(IPV6_REGEX_PATTERN, data);
        }
    }

    public String getRecord(String name, RecordType type) throws IOException {
        this.checkDomainNameAvailability(name, false);
        try {
            return this.callFuncReturningString(GET_RECORD, ContractParameter.string((String)name), ContractParameter.integer((byte)type.byteValue()));
        }
        catch (InvocationFaultStateException e) {
            throw new InvocationFaultStateException(String.format("Could not get any record of type '%s' for the domain name '%s'.", type.jsonValue(), name), e.getMessage());
        }
    }

    public TransactionBuilder deleteRecord(String name, RecordType type) {
        return this.invokeFunction(DELETE_RECORD, ContractParameter.string((String)name), ContractParameter.integer((byte)type.byteValue()));
    }

    public String resolve(String name, RecordType type) throws IOException {
        this.checkDomainNameAvailability(name, false);
        try {
            return this.callFuncReturningString(RESOLVE, ContractParameter.string((String)name), ContractParameter.integer((byte)type.byteValue()));
        }
        catch (UnexpectedReturnTypeException e) {
            throw new IllegalArgumentException("No record of type " + type.jsonValue() + " found for the domain name '" + name + "'.");
        }
    }

    public Hash160 ownerOf(String name) throws IOException {
        this.checkDomainNameAvailability(name, false);
        return this.ownerOf(name.getBytes(StandardCharsets.UTF_8));
    }

    public NameState getNameState(String name) throws IOException {
        return this.getNameState(name.getBytes(StandardCharsets.UTF_8));
    }

    public NameState getNameState(byte[] name) throws IOException {
        String domainAsString = new String(name, StandardCharsets.UTF_8);
        this.checkDomainNameAvailability(domainAsString, false);
        InvocationResult invocationResult = this.callInvokeFunction(PROPERTIES, Arrays.asList(ContractParameter.byteArray((byte[])name)), new Signer[0]).getInvocationResult();
        return this.deserializeNameState(invocationResult);
    }

    private NameState deserializeNameState(InvocationResult invocationResult) {
        this.throwIfFaultState(invocationResult);
        StackItem stackItem = (StackItem)invocationResult.getStack().get(0);
        if (!stackItem.getType().equals((Object)StackItemType.MAP)) {
            throw new UnexpectedReturnTypeException(stackItem.getType(), StackItemType.MAP);
        }
        Map map = stackItem.getMap();
        String name = ((StackItem)map.get(NAME_PROPERTY)).getString();
        BigInteger expiration = ((StackItem)map.get(EXPIRATION_PROPERTY)).getInteger();
        StackItem adminStackItem = (StackItem)map.get(ADMIN_PROPERTY);
        if (adminStackItem == null || adminStackItem.getValue() == null) {
            return new NameState(name, Long.valueOf(expiration.longValue()), null);
        }
        Hash160 admin = Hash160.fromAddress((String)adminStackItem.getAddress());
        return new NameState(name, Long.valueOf(expiration.longValue()), admin);
    }

    public TransactionBuilder transfer(Account from, Hash160 to, String name) throws IOException {
        return this.transfer(from, to, name, null);
    }

    public TransactionBuilder transfer(Account from, Hash160 to, String name, ContractParameter data) throws IOException {
        this.checkDomainNameAvailability(name, false);
        return this.transfer(from, to, name.getBytes(StandardCharsets.UTF_8), data);
    }
}

