/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.exceptions.UnexpectedReturnTypeException;
import io.neow3j.crypto.Hash;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.IOUtils;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.types.CallFlags;
import io.neow3j.types.Hash160;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NefFile
extends NeoSerializable {
    private static final int MAGIC = 860243278;
    private static final int MAGIC_SIZE = 4;
    private static final int COMPILER_SIZE = 64;
    private static final int MAX_SOURCE_URL_SIZE = 256;
    private static final int MAX_SCRIPT_LENGTH = 524288;
    private static final int CHECKSUM_SIZE = 4;
    private static final int HEADER_SIZE = 68;
    private String compiler;
    private String sourceUrl;
    private List<MethodToken> methodTokens;
    private byte[] checkSum;
    private byte[] script;

    public NefFile() {
        this.sourceUrl = "";
        this.methodTokens = new ArrayList<MethodToken>();
        this.script = new byte[0];
        this.checkSum = new byte[0];
    }

    public NefFile(String compiler, String sourceUrl, List<MethodToken> methodTokens, byte[] script) {
        int compilerSize = compiler.getBytes(StandardCharsets.UTF_8).length;
        if (compilerSize > 64) {
            throw new IllegalArgumentException(String.format("The compiler name and version string can be max %d bytes long, but was %d bytes long.", 64, compilerSize));
        }
        this.compiler = compiler;
        this.sourceUrl = sourceUrl == null ? "" : sourceUrl;
        ArrayList arrayList = this.methodTokens = methodTokens == null ? new ArrayList() : methodTokens;
        if (this.sourceUrl.getBytes(StandardCharsets.UTF_8).length >= 256) {
            throw new IllegalArgumentException("The source URL must not be longer than 256 bytes");
        }
        this.script = script;
        this.checkSum = new byte[4];
        this.checkSum = NefFile.computeChecksum(this);
    }

    public NefFile(String compiler, List<MethodToken> methodTokens, byte[] script) {
        this(compiler, "", methodTokens, script);
    }

    public String getCompiler() {
        return this.compiler;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public List<MethodToken> getMethodTokens() {
        return this.methodTokens;
    }

    public byte[] getScript() {
        return this.script;
    }

    public byte[] getCheckSum() {
        return this.checkSum;
    }

    public long getCheckSumAsInteger() {
        return NefFile.getCheckSumAsInteger(this.checkSum);
    }

    public static long getCheckSumAsInteger(byte[] checkSumBytes) {
        return Numeric.toBigInt((byte[])ArrayUtils.reverseArray((byte[])checkSumBytes)).longValue();
    }

    public int getSize() {
        return 68 + IOUtils.getVarSize((String)this.sourceUrl) + 1 + IOUtils.getVarSize(this.methodTokens) + 2 + IOUtils.getVarSize((byte[])this.script) + 4;
    }

    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeUInt32(860243278L);
        writer.writeFixedString(this.compiler, 64);
        writer.writeVarString(this.sourceUrl);
        writer.writeByte((byte)0);
        writer.writeSerializableVariable(this.methodTokens);
        writer.writeUInt16(0);
        writer.writeVarBytes(this.script);
        writer.write(this.checkSum);
    }

    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            if (reader.readUInt32() != 860243278L) {
                throw new DeserializationException("Wrong magic number in NEF file.");
            }
            byte[] compilerBytes = reader.readBytes(64);
            this.compiler = new String(ArrayUtils.trimTrailingBytes((byte[])compilerBytes, (byte)0), StandardCharsets.UTF_8);
            this.sourceUrl = reader.readVarString();
            if (this.sourceUrl != null && this.sourceUrl.getBytes(StandardCharsets.UTF_8).length >= 256) {
                throw new DeserializationException("Source URL must not be longer than 256 bytes.");
            }
            if (reader.readByte() != 0) {
                throw new DeserializationException("Reserve bytes in NEF file must be 0.");
            }
            this.methodTokens = reader.readSerializableList(MethodToken.class);
            if (reader.readUInt16() != 0) {
                throw new DeserializationException("Reserve bytes in NEF file must be 0.");
            }
            this.script = reader.readVarBytes(524288);
            if (this.script.length == 0) {
                throw new DeserializationException("Script cannot be empty in NEF file.");
            }
            this.checkSum = reader.readBytes(4);
            if (!Arrays.equals(this.checkSum, NefFile.computeChecksum(this))) {
                throw new DeserializationException("The checksums did not match");
            }
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public static byte[] computeChecksum(NefFile file) {
        byte[] serialized = file.toArray();
        return NefFile.computeChecksumFromBytes(serialized);
    }

    public static byte[] computeChecksumFromBytes(byte[] fileBytes) {
        int fileSizeWithoutCheckSum = fileBytes.length - 4;
        byte[] nefFileBytes = ArrayUtils.getFirstNBytes((byte[])fileBytes, (int)fileSizeWithoutCheckSum);
        return ArrayUtils.getFirstNBytes((byte[])Hash.hash256((byte[])nefFileBytes), (int)4);
    }

    public static NefFile readFromFile(File nefFile) throws DeserializationException, IOException {
        int nefFileSize = (int)nefFile.length();
        if (nefFileSize > 0x100000) {
            throw new IllegalArgumentException("The given NEF file is too large. File was " + nefFileSize + " bytes, but a max of 2^20 bytes is allowed.");
        }
        try (FileInputStream nefStream = new FileInputStream(nefFile);){
            BinaryReader reader = new BinaryReader((InputStream)nefStream);
            NefFile nefFile2 = (NefFile)reader.readSerializable(NefFile.class);
            return nefFile2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NefFile readFromStackItem(StackItem stackItem) throws DeserializationException {
        if (!stackItem.getType().equals((Object)StackItemType.BYTE_STRING)) {
            throw new UnexpectedReturnTypeException(stackItem.getType(), StackItemType.BYTE_STRING);
        }
        byte[] nefBytes = stackItem.getByteArray();
        try (ByteArrayInputStream nefStream = new ByteArrayInputStream(nefBytes);){
            BinaryReader reader = new BinaryReader((InputStream)nefStream);
            NefFile nefFile = (NefFile)reader.readSerializable(NefFile.class);
            return nefFile;
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static class MethodToken
    extends NeoSerializable {
        private static final int PARAMS_COUNT_SIZE = 2;
        private static final int HAS_RETURN_VALUE_SIZE = 1;
        private static final int CALL_FLAGS_SIZE = 1;
        private Hash160 hash;
        private String method;
        private int parametersCount;
        private boolean hasReturnValue;
        private CallFlags callFlags;

        public MethodToken(Hash160 hash, String method, int parametersCount, boolean hasReturnValue, CallFlags callFlags) {
            this.hash = hash;
            this.method = method;
            this.parametersCount = parametersCount;
            this.hasReturnValue = hasReturnValue;
            this.callFlags = callFlags;
        }

        public MethodToken() {
        }

        public Hash160 getHash() {
            return this.hash;
        }

        public String getMethod() {
            return this.method;
        }

        public int getParametersCount() {
            return this.parametersCount;
        }

        public boolean hasReturnValue() {
            return this.hasReturnValue;
        }

        public CallFlags getCallFlags() {
            return this.callFlags;
        }

        public void deserialize(BinaryReader reader) throws DeserializationException {
            try {
                this.hash = (Hash160)reader.readSerializable(Hash160.class);
                this.method = reader.readVarString();
                this.parametersCount = reader.readUInt16();
                this.hasReturnValue = reader.readBoolean();
                this.callFlags = CallFlags.valueOf((byte)reader.readByte());
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }

        public void serialize(BinaryWriter writer) throws IOException {
            writer.writeSerializableFixed((NeoSerializable)this.hash);
            writer.writeVarString(this.method);
            writer.writeUInt16(this.parametersCount);
            writer.writeBoolean(this.hasReturnValue);
            writer.writeByte(this.callFlags.getValue());
        }

        public int getSize() {
            return 20 + IOUtils.getVarSize((String)this.method) + 2 + 1 + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodToken)) {
                return false;
            }
            MethodToken that = (MethodToken)((Object)o);
            return this.parametersCount == that.parametersCount && this.hasReturnValue == that.hasReturnValue && this.hash.equals((Object)that.hash) && this.method.equals(that.method) && this.callFlags == that.callFlags;
        }

        public int hashCode() {
            int result = this.hash != null ? this.hash.hashCode() : 0;
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + this.parametersCount;
            result = 31 * result + (this.hasReturnValue ? 1 : 0);
            result = 31 * result + (this.callFlags != null ? this.callFlags.hashCode() : 0);
            return result;
        }
    }
}

