/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import io.neow3j.contract.Token;
import io.neow3j.contract.exceptions.UnexpectedReturnTypeException;
import io.neow3j.protocol.Neow3j;
import io.neow3j.transaction.AccountSigner;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import io.neow3j.wallet.Account;
import io.neow3j.wallet.Wallet;
import java.io.IOException;
import java.math.BigInteger;

public class FungibleToken
extends Token {
    private static final String BALANCE_OF = "balanceOf";
    private static final String TRANSFER = "transfer";

    public FungibleToken(Hash160 scriptHash, Neow3j neow) {
        super(scriptHash, neow);
    }

    public BigInteger getBalanceOf(Account account) throws IOException, UnexpectedReturnTypeException {
        return this.getBalanceOf(account.getScriptHash());
    }

    public BigInteger getBalanceOf(Hash160 scriptHash) throws IOException, UnexpectedReturnTypeException {
        ContractParameter ofParam = ContractParameter.hash160((Hash160)scriptHash);
        return this.callFuncReturningInt(BALANCE_OF, ofParam);
    }

    public BigInteger getBalanceOf(Wallet wallet) throws IOException, UnexpectedReturnTypeException {
        BigInteger sum = BigInteger.ZERO;
        for (Account a : wallet.getAccounts()) {
            sum = sum.add(this.getBalanceOf(a.getScriptHash()));
        }
        return sum;
    }

    public TransactionBuilder transfer(Account from, Hash160 to, BigInteger amount) throws IOException {
        return this.transfer(from, to, amount, null);
    }

    public TransactionBuilder transfer(Account from, Hash160 to, BigInteger amount, ContractParameter data) throws IOException {
        return this.transfer(from.getScriptHash(), to, amount, data).signers(new Signer[]{AccountSigner.calledByEntry((Account)from)});
    }

    public TransactionBuilder transfer(Hash160 from, Hash160 to, BigInteger amount) throws IOException {
        return this.transfer(from, to, amount, null);
    }

    public TransactionBuilder transfer(Hash160 from, Hash160 to, BigInteger amount, ContractParameter data) throws IOException {
        if (amount.signum() < 0) {
            throw new IllegalArgumentException("The amount must be greater than or equal to 0");
        }
        byte[] transferScript = this.buildTransferScript(from, to, amount, data);
        return new TransactionBuilder(this.neow3j).script(transferScript);
    }

    public byte[] buildTransferScript(Hash160 from, Hash160 to, BigInteger amount, ContractParameter data) {
        return this.buildInvokeFunctionScript(TRANSFER, ContractParameter.hash160((Hash160)from), ContractParameter.hash160((Hash160)to), ContractParameter.integer((BigInteger)amount), data);
    }
}

