/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.contract;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.neow3j.contract.NefFile;
import io.neow3j.contract.SmartContract;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.ObjectMapperFactory;
import io.neow3j.protocol.core.response.ContractManifest;
import io.neow3j.transaction.TransactionBuilder;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import java.io.IOException;
import java.math.BigInteger;

public class ContractManagement
extends SmartContract {
    private static final String NAME = "ContractManagement";
    public static final Hash160 SCRIPT_HASH = ContractManagement.calcNativeContractHash("ContractManagement");
    private static final String GET_MINIMUM_DEPLOYMENT_FEE = "getMinimumDeploymentFee";
    private static final String SET_MINIMUM_DEPLOYMENT_FEE = "setMinimumDeploymentFee";
    private static final String DEPLOY = "deploy";

    public ContractManagement(Neow3j neow) {
        super(SCRIPT_HASH, neow);
    }

    public BigInteger getMinimumDeploymentFee() throws IOException {
        return this.callFuncReturningInt(GET_MINIMUM_DEPLOYMENT_FEE, new ContractParameter[0]);
    }

    public TransactionBuilder setMinimumDeploymentFee(BigInteger minimumFee) {
        return this.invokeFunction(SET_MINIMUM_DEPLOYMENT_FEE, ContractParameter.integer((BigInteger)minimumFee));
    }

    public TransactionBuilder deploy(NefFile nef, ContractManifest manifest) throws JsonProcessingException {
        return this.deploy(nef, manifest, null);
    }

    public TransactionBuilder deploy(NefFile nef, ContractManifest manifest, ContractParameter data) throws JsonProcessingException {
        if (nef == null) {
            throw new IllegalArgumentException("The NEF file cannot be null.");
        }
        if (manifest == null) {
            throw new IllegalArgumentException("The manifest cannot be null.");
        }
        byte[] manifestBytes = ObjectMapperFactory.getObjectMapper().writeValueAsBytes((Object)manifest);
        if (manifestBytes.length > 65535) {
            throw new IllegalArgumentException(String.format("The given contract manifest is too long. Manifest was %d bytes big, but a max of %d bytes is allowed.", manifestBytes.length, 65535));
        }
        if (data == null) {
            return this.invokeFunction(DEPLOY, ContractParameter.byteArray((byte[])nef.toArray()), ContractParameter.byteArray((byte[])manifestBytes));
        }
        return this.invokeFunction(DEPLOY, ContractParameter.byteArray((byte[])nef.toArray()), ContractParameter.byteArray((byte[])manifestBytes), data);
    }
}

