/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.sourcelookup;

import io.neow3j.compiler.sourcelookup.CompositeSourceContainer;
import io.neow3j.compiler.sourcelookup.ISourceContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DirectorySourceContainer
extends CompositeSourceContainer {
    private File directory;
    private boolean searchSubDirs;

    public DirectorySourceContainer(File directory, boolean searchSubDirs) {
        this.directory = directory;
        this.searchSubDirs = searchSubDirs;
    }

    @Override
    public File findSourceFile(String name) {
        File file = new File(this.directory, name);
        if (file.exists() && file.isFile()) {
            return file;
        }
        if (this.searchSubDirs) {
            for (ISourceContainer container : this.getSourceContainers()) {
                file = container.findSourceFile(name);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    @Override
    protected List<ISourceContainer> createSourceContainers() {
        String[] files;
        ArrayList<ISourceContainer> dirs = new ArrayList<ISourceContainer>();
        if (this.searchSubDirs && (files = this.directory.list()) != null) {
            for (String name : files) {
                File file = new File(this.directory, name);
                if (!file.exists() || !file.isDirectory()) continue;
                dirs.add(new DirectorySourceContainer(file, true));
            }
        }
        return dirs;
    }
}

