/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.converters;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.LocalVariableHelper;
import io.neow3j.compiler.NeoEvent;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.SuperNeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.devpack.annotations.Instruction;
import io.neow3j.devpack.annotations.Struct;
import io.neow3j.script.InteropService;
import io.neow3j.script.OpCode;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.ClassUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ObjectsConverter
implements Converter {
    private static final String APPEND_METHOD_NAME = "append";
    private static final String TOSTRING_METHOD_NAME = "toString";

    @Override
    public AbstractInsnNode convert(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        JVMOpcode opcode = JVMOpcode.get(insn.getOpcode());
        switch (Objects.requireNonNull(opcode)) {
            case PUTSTATIC: {
                ObjectsConverter.addStoreStaticField((FieldInsnNode)insn, neoMethod, compUnit);
                break;
            }
            case GETSTATIC: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (Compiler.isEvent(fieldInsn.desc, compUnit)) {
                    insn = ObjectsConverter.convertEvent(fieldInsn, neoMethod, compUnit);
                    break;
                }
                if (Compiler.isAssertionDisabledStaticField((AbstractInsnNode)fieldInsn)) {
                    insn = fieldInsn.getNext();
                    break;
                }
                ObjectsConverter.addLoadStaticField(fieldInsn, neoMethod, compUnit);
                break;
            }
            case CHECKCAST: {
                break;
            }
            case NEW: {
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                if (this.isStruct(typeInsn.desc, compUnit)) {
                    insn = ObjectsConverter.handleNewStruct(insn, neoMethod, compUnit);
                    break;
                }
                insn = ObjectsConverter.handleNew(insn, neoMethod, compUnit);
                break;
            }
            case ARRAYLENGTH: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.SIZE));
                break;
            }
            case INSTANCEOF: {
                this.handleInstanceOf((TypeInsnNode)insn, neoMethod);
            }
        }
        return insn;
    }

    private boolean isStruct(String desc, CompilationUnit compUnit) throws IOException {
        ClassNode asmClass = AsmHelper.getAsmClass(ClassUtils.getFullyQualifiedNameForInternalName((String)desc), compUnit.getClassLoader());
        return AsmHelper.hasAnnotations(asmClass, Struct.class);
    }

    private void handleInstanceOf(TypeInsnNode typeInsn, NeoMethod neoMethod) {
        Type type = Type.getObjectType((String)typeInsn.desc);
        StackItemType stackItemType = Compiler.mapTypeToStackItemType(type);
        if (stackItemType.equals((Object)StackItemType.BOOLEAN)) {
            stackItemType = StackItemType.INTEGER;
        }
        if (stackItemType.equals((Object)StackItemType.ANY)) {
            throw new CompilerException(neoMethod, String.format("The type '%s' is not supported for the instanceof operation.", ClassUtils.getFullyQualifiedNameForInternalName((String)type.getInternalName())));
        }
        neoMethod.addInstruction(new NeoInstruction(OpCode.ISTYPE, new byte[]{stackItemType.byteValue()}));
    }

    public static void addLoadStaticField(FieldInsnNode fieldInsn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        int neoVmIdx = compUnit.getNeoModule().getContractVariable(fieldInsn, compUnit).getNeoIdx();
        neoMethod.addInstruction(LocalVariableHelper.buildStoreOrLoadVariableInsn(neoVmIdx, OpCode.LDSFLD));
    }

    public static void addStoreStaticField(FieldInsnNode fieldInsn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        int neoVmIdx = compUnit.getNeoModule().getContractVariable(fieldInsn, compUnit).getNeoIdx();
        neoMethod.addInstruction(LocalVariableHelper.buildStoreOrLoadVariableInsn(neoVmIdx, OpCode.STSFLD));
    }

    public static AbstractInsnNode handleNewStruct(AbstractInsnNode insn, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        TypeInsnNode typeInsn = (TypeInsnNode)insn;
        assert (typeInsn.getNext().getOpcode() == JVMOpcode.DUP.getOpcode()) : "Expected DUP after NEW but got other instructions";
        ClassNode ownerClassNode = AsmHelper.getAsmClassForInternalName(typeInsn.desc, compUnit.getClassLoader());
        MethodInsnNode ctorMethodInsn = Compiler.skipToCtorCall(typeInsn.getNext(), ownerClassNode);
        MethodNode ctorMethod = AsmHelper.getMethodNode(ctorMethodInsn, ownerClassNode).orElseThrow(() -> new CompilerException(callingNeoMethod, String.format("Couldn't find constructor '%s' on class '%s'.", ctorMethodInsn.name, ClassUtils.getClassNameForInternalName((String)ownerClassNode.name))));
        if (ctorMethod.invisibleAnnotations == null || ctorMethod.invisibleAnnotations.size() == 0) {
            return ObjectsConverter.convertStructConstructorCall(typeInsn, ctorMethod, ownerClassNode, callingNeoMethod, compUnit);
        }
        insn = insn.getNext().getNext();
        while (!Compiler.isCallToCtor(insn, ownerClassNode.name)) {
            insn = Compiler.handleInsn(insn, callingNeoMethod, compUnit);
            insn = insn.getNext();
        }
        if (AsmHelper.hasAnnotations(ctorMethod, Instruction.class, Instruction.Instructions.class)) {
            Compiler.processInstructionAnnotations(ctorMethod, callingNeoMethod);
        }
        return insn;
    }

    public static AbstractInsnNode handleNew(AbstractInsnNode insn, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        TypeInsnNode typeInsn = (TypeInsnNode)insn;
        assert (typeInsn.getNext().getOpcode() == JVMOpcode.DUP.getOpcode()) : "Expected DUP after NEW but got other instructions";
        if (ObjectsConverter.isNewStringBuilder(typeInsn)) {
            return ObjectsConverter.handleStringConcatenation(typeInsn, callingNeoMethod, compUnit);
        }
        if (ObjectsConverter.isAssertion(typeInsn, compUnit)) {
            return ObjectsConverter.handleAssertion(typeInsn, callingNeoMethod);
        }
        if (ObjectsConverter.isNewException(typeInsn, compUnit)) {
            return ObjectsConverter.handleNewException(typeInsn, callingNeoMethod, compUnit);
        }
        ClassNode owner = AsmHelper.getAsmClassForInternalName(typeInsn.desc, compUnit.getClassLoader());
        MethodInsnNode ctorMethodInsn = Compiler.skipToCtorCall(typeInsn.getNext(), owner);
        MethodNode ctorMethod = AsmHelper.getMethodNode(ctorMethodInsn, owner).orElseThrow(() -> new CompilerException(callingNeoMethod, String.format("Couldn't find constructor '%s' on class '%s'.", ctorMethodInsn.name, ClassUtils.getClassNameForInternalName((String)owner.name))));
        if (ctorMethod.invisibleAnnotations == null || ctorMethod.invisibleAnnotations.size() == 0) {
            return ObjectsConverter.convertConstructorCall(typeInsn, ctorMethod, owner, callingNeoMethod, compUnit);
        }
        insn = insn.getNext().getNext();
        while (!Compiler.isCallToCtor(insn, owner.name)) {
            insn = Compiler.handleInsn(insn, callingNeoMethod, compUnit);
            insn = insn.getNext();
        }
        if (AsmHelper.hasAnnotations(ctorMethod, Instruction.class, Instruction.Instructions.class)) {
            Compiler.processInstructionAnnotations(ctorMethod, callingNeoMethod);
        }
        return insn;
    }

    private static boolean isNewStringBuilder(TypeInsnNode typeInsn) {
        return typeInsn.desc.equals(Type.getInternalName(StringBuilder.class));
    }

    private static boolean isAssertion(TypeInsnNode typeInsn, CompilationUnit compUnit) throws IOException {
        ClassNode type = AsmHelper.getAsmClassForInternalName(typeInsn.desc, compUnit.getClassLoader());
        if (ClassUtils.getFullyQualifiedNameForInternalName((String)type.name).equals(AssertionError.class.getCanonicalName())) {
            return true;
        }
        while (type.superName != null) {
            type = AsmHelper.getAsmClassForInternalName(type.superName, compUnit.getClassLoader());
            if (!ClassUtils.getFullyQualifiedNameForInternalName((String)type.name).equals(AssertionError.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNewException(TypeInsnNode typeInsn, CompilationUnit compUnit) throws IOException {
        ClassNode type = AsmHelper.getAsmClassForInternalName(typeInsn.desc, compUnit.getClassLoader());
        if (ClassUtils.getFullyQualifiedNameForInternalName((String)type.name).equals(Exception.class.getCanonicalName())) {
            return true;
        }
        while (type.superName != null) {
            type = AsmHelper.getAsmClassForInternalName(type.superName, compUnit.getClassLoader());
            if (!ClassUtils.getFullyQualifiedNameForInternalName((String)type.name).equals(Exception.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private static AbstractInsnNode handleAssertion(TypeInsnNode typeInsn, NeoMethod callingNeoMethod) {
        ObjectsConverter.convertJumpConditionBeforeAssertion(callingNeoMethod);
        AbstractInsnNode insn = typeInsn.getNext().getNext();
        while (!Compiler.isCallToCtor(insn, Type.getType(AssertionError.class).getInternalName())) {
            insn = insn.getNext();
        }
        Type[] argTypes = Type.getType((String)((MethodInsnNode)insn).desc).getArgumentTypes();
        if (argTypes.length != 0) {
            throw new CompilerException("Passing a message with the 'assert' statement is not supported.");
        }
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.ASSERT));
        return insn.getNext();
    }

    private static void convertJumpConditionBeforeAssertion(NeoMethod neoMethod) {
        if (neoMethod.getInstructions().size() == 0) {
            throw new CompilerException(String.format("The method '%s' seems to hold a hard coded 'assert false' statement or it throws an 'AssertionError'. The compiler does not support that. Use 'Helper.abort()' instead.", neoMethod.getName()));
        }
        NeoInstruction lastInstruction = neoMethod.getLastInstruction();
        neoMethod.removeLastInstruction();
        switch (lastInstruction.getOpcode()) {
            case JMPEQ: 
            case JMPEQ_L: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.EQUAL));
                break;
            }
            case JMPNE: 
            case JMPNE_L: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.NOTEQUAL));
                break;
            }
            case JMPLT: 
            case JMPLT_L: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.LT));
                break;
            }
            case JMPGT: 
            case JMPGT_L: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.GT));
                break;
            }
            case JMPLE: 
            case JMPLE_L: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.LE));
                break;
            }
            case JMPGE: 
            case JMPGE_L: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.GE));
                break;
            }
            case JMPIFNOT: 
            case JMPIFNOT_L: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.NOT));
                break;
            }
            case JMPIF: 
            case JMPIF_L: {
                break;
            }
            default: {
                throw new CompilerException("Could not handle jump condition. The compiler does not support hard coded 'assert false' statements nor throwing an 'AssertionError'. Use 'Helper.abort()' instead.");
            }
        }
    }

    private static AbstractInsnNode handleNewException(TypeInsnNode typeInsn, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        String fullyQualifiedExceptionName = ClassUtils.getFullyQualifiedNameForInternalName((String)typeInsn.desc);
        if (!fullyQualifiedExceptionName.equals(Exception.class.getCanonicalName())) {
            throw new CompilerException(callingNeoMethod, String.format("Contract uses exception of type %s but only %s is allowed.", fullyQualifiedExceptionName, Exception.class.getCanonicalName()));
        }
        AbstractInsnNode insn = typeInsn.getNext().getNext();
        while (!Compiler.isCallToCtor(insn, Type.getType(Exception.class).getInternalName())) {
            insn = Compiler.handleInsn(insn, callingNeoMethod, compUnit);
            insn = insn.getNext();
        }
        Type[] argTypes = Type.getType((String)((MethodInsnNode)insn).desc).getArgumentTypes();
        if (argTypes.length > 1) {
            throw new CompilerException(callingNeoMethod, String.format("An exception thrown in a contract can either take no arguments or a String argument. You provided %d arguments.", argTypes.length));
        }
        if (argTypes.length == 1) {
            if (!ClassUtils.getFullyQualifiedNameForInternalName((String)argTypes[0].getInternalName()).equals(String.class.getCanonicalName())) {
                throw new CompilerException(callingNeoMethod, "An exception thrown in a contract can either take no arguments or a String argument. You provided a non-string argument.");
            }
        } else {
            String dummyMessage = "error";
            callingNeoMethod.addInstruction(Compiler.buildPushDataInsn(dummyMessage));
        }
        return insn;
    }

    private static AbstractInsnNode handleStringConcatenation(TypeInsnNode typeInsnNode, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        AbstractInsnNode insn = typeInsnNode.getNext().getNext().getNext();
        boolean isFirstCall = true;
        while (insn != null) {
            if (ObjectsConverter.isCallToStringBuilderAppend(insn)) {
                if (!isFirstCall) {
                    neoMethod.addInstruction(new NeoInstruction(OpCode.CAT));
                }
                isFirstCall = false;
                insn = insn.getNext();
                continue;
            }
            if (ObjectsConverter.isCallToStringBuilderToString(insn)) {
                neoMethod.addInstruction(new NeoInstruction(OpCode.CONVERT, new byte[]{StackItemType.BYTE_STRING.byteValue()}));
                break;
            }
            if (ObjectsConverter.isCallToAnyStringBuilderMethod(insn)) {
                throw new CompilerException(neoMethod, String.format("Only 'append()' and 'toString()' are supported for StringBuilder, but '%s' was called", ((MethodInsnNode)insn).name));
            }
            insn = Compiler.handleInsn(insn, neoMethod, compUnit);
            insn = insn.getNext();
        }
        if (insn == null) {
            throw new CompilerException(neoMethod, "Expected to find ScriptBuilder.toString() but reached end of method.");
        }
        return insn;
    }

    private static boolean isCallToStringBuilderAppend(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).owner.equals(Type.getInternalName(StringBuilder.class)) && ((MethodInsnNode)insn).name.equals(APPEND_METHOD_NAME);
    }

    private static boolean isCallToStringBuilderToString(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).owner.equals(Type.getInternalName(StringBuilder.class)) && ((MethodInsnNode)insn).name.equals(TOSTRING_METHOD_NAME);
    }

    private static boolean isCallToAnyStringBuilderMethod(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).owner.equals(Type.getInternalName(StringBuilder.class));
    }

    private static AbstractInsnNode convertStructConstructorCall(TypeInsnNode typeInsnNode, MethodNode ctorMethod, ClassNode structClassNode, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        SuperNeoMethod calledNeoMethod;
        String ctorMethodId = NeoMethod.getMethodId(ctorMethod, structClassNode);
        int fieldSize = ObjectsConverter.calculateFieldSize(structClassNode, compUnit);
        if (compUnit.getNeoModule().hasMethod(ctorMethodId)) {
            calledNeoMethod = (SuperNeoMethod)compUnit.getNeoModule().getMethod(ctorMethodId);
        } else {
            calledNeoMethod = new SuperNeoMethod(ctorMethod, structClassNode);
            compUnit.getNeoModule().addMethod(calledNeoMethod);
            calledNeoMethod.initialize(compUnit);
            calledNeoMethod.convert(compUnit);
        }
        return ObjectsConverter.finalizeConstructorCall(fieldSize, typeInsnNode, ctorMethod, structClassNode, callingNeoMethod, calledNeoMethod, compUnit);
    }

    private static AbstractInsnNode finalizeConstructorCall(int fieldSize, TypeInsnNode typeInsnNode, MethodNode ctorMethod, ClassNode structClassNode, NeoMethod callingNeoMethod, NeoMethod calledNeoMethod, CompilationUnit compUnit) throws IOException {
        Compiler.addPushNumber(fieldSize, callingNeoMethod);
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.NEWARRAY));
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.DUP));
        AbstractInsnNode insn = typeInsnNode.getNext().getNext();
        while (!Compiler.isCallToCtor(insn, structClassNode.name)) {
            insn = Compiler.handleInsn(insn, callingNeoMethod, compUnit);
            insn = insn.getNext();
        }
        Compiler.addReverseArguments(ctorMethod, callingNeoMethod);
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.CALL_L, new byte[4]).setExtra(calledNeoMethod));
        return insn;
    }

    private static int calculateFieldSize(ClassNode structClassNode, CompilationUnit compUnit) throws IOException {
        int fieldSize = structClassNode.fields.size();
        ClassNode currentClassNode = structClassNode;
        while (!ClassUtils.getFullyQualifiedNameForInternalName((String)currentClassNode.superName).equals(Object.class.getCanonicalName())) {
            ObjectsConverter.throwIfSuperIsNotStruct(currentClassNode.superName, compUnit);
            currentClassNode = AsmHelper.getAsmClass(currentClassNode.superName, compUnit.getClassLoader());
            fieldSize += currentClassNode.fields.size();
        }
        return fieldSize;
    }

    private static void throwIfSuperIsNotStruct(String superName, CompilationUnit compUnit) throws IOException {
        ClassNode superClassNode = AsmHelper.getAsmClass(superName, compUnit.getClassLoader());
        if (!AsmHelper.hasAnnotations(superClassNode, Struct.class)) {
            throw new CompilerException(String.format("Struct classes are not allowed to inherit non-struct classes. %s was inherited by a struct class.", superName));
        }
    }

    private static AbstractInsnNode convertConstructorCall(TypeInsnNode typeInsn, MethodNode ctorMethod, ClassNode classNode, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        NeoMethod calledNeoMethod;
        String ctorMethodId = NeoMethod.getMethodId(ctorMethod, classNode);
        if (compUnit.getNeoModule().hasMethod(ctorMethodId)) {
            calledNeoMethod = compUnit.getNeoModule().getMethod(ctorMethodId);
        } else {
            calledNeoMethod = new NeoMethod(ctorMethod, classNode);
            compUnit.getNeoModule().addMethod(calledNeoMethod);
            calledNeoMethod.initialize(compUnit);
            MethodInsnNode insn = Compiler.skipToSuperCtorCall(ctorMethod, classNode);
            for (insn = insn.getNext(); insn != null; insn = insn.getNext()) {
                insn = Compiler.handleInsn((AbstractInsnNode)insn, calledNeoMethod, compUnit);
            }
        }
        int fieldSize = classNode.fields.size();
        return ObjectsConverter.finalizeConstructorCall(fieldSize, typeInsn, ctorMethod, classNode, callingNeoMethod, calledNeoMethod, compUnit);
    }

    private static AbstractInsnNode convertEvent(FieldInsnNode eventFieldInsn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        if (neoMethod.isVerifyMethod()) {
            throw new CompilerException(neoMethod, "The verify method is not allowed to fire any event.");
        }
        String eventVariableName = eventFieldInsn.name;
        List<NeoEvent> events = compUnit.getNeoModule().getEvents();
        NeoEvent event = events.stream().filter(e -> eventVariableName.equals(e.getAsmVariable().name)).findFirst().orElseThrow(() -> new CompilerException(neoMethod, "Couldn't find triggered event in list of events. Make sure to declare events only in the main contract class."));
        AbstractInsnNode insn = eventFieldInsn.getNext();
        while (!ObjectsConverter.isMethodCallToEventSend(insn, compUnit)) {
            insn = Compiler.handleInsn(insn, neoMethod, compUnit);
            insn = insn.getNext();
            assert (insn != null) : "Expected to find call to send() method of an event but reached the end of the instructions.";
        }
        Compiler.addReverseArguments(neoMethod, event.getNumberOfParams());
        Compiler.addPushNumber(event.getNumberOfParams(), neoMethod);
        neoMethod.addInstruction(new NeoInstruction(OpCode.PACK));
        neoMethod.addInstruction(Compiler.buildPushDataInsn(event.getDisplayName()));
        byte[] syscallHash = Numeric.hexStringToByteArray((String)InteropService.SYSTEM_RUNTIME_NOTIFY.getHash());
        neoMethod.addInstruction(new NeoInstruction(OpCode.SYSCALL, syscallHash));
        return insn;
    }

    private static boolean isMethodCallToEventSend(AbstractInsnNode insn, CompilationUnit compUnit) throws IOException {
        if (!(insn instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode methodInsn = (MethodInsnNode)insn;
        return Compiler.isEvent(Type.getObjectType((String)methodInsn.owner).getDescriptor(), compUnit);
    }
}

