/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.converters;

import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.script.OpCode;
import io.neow3j.utils.ClassUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class ConstantsConverter
implements Converter {
    private static final String DESIRED_ASSERTION_STATUS = "desiredAssertionStatus";

    @Override
    public AbstractInsnNode convert(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) {
        JVMOpcode opcode = JVMOpcode.get(insn.getOpcode());
        switch (opcode) {
            case ICONST_M1: 
            case ICONST_0: 
            case ICONST_1: 
            case ICONST_2: 
            case ICONST_3: 
            case ICONST_4: 
            case ICONST_5: {
                Compiler.addPushNumber(opcode.getOpcode() - 3, neoMethod);
                break;
            }
            case LCONST_0: {
                Compiler.addPushNumber(0L, neoMethod);
                break;
            }
            case LCONST_1: {
                Compiler.addPushNumber(1L, neoMethod);
                break;
            }
            case LDC: 
            case LDC_W: 
            case LDC2_W: {
                if (this.isDesiredAssertionStatusConst(insn)) {
                    while (!Compiler.isAssertionDisabledStaticField(insn)) {
                        insn = insn.getNext();
                    }
                    insn = insn.getNext();
                    break;
                }
                Compiler.addLoadConstant(insn, neoMethod);
                break;
            }
            case ACONST_NULL: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.PUSHNULL));
                break;
            }
            case BIPUSH: 
            case SIPUSH: {
                Compiler.addPushNumber(((IntInsnNode)insn).operand, neoMethod);
            }
        }
        return insn;
    }

    private boolean isDesiredAssertionStatusConst(AbstractInsnNode insn) {
        if (insn.getNext().getType() != 5) {
            return false;
        }
        MethodInsnNode methodInsn = (MethodInsnNode)insn.getNext();
        return methodInsn.name.equals(DESIRED_ASSERTION_STATUS) && ClassUtils.getFullyQualifiedNameForInternalName((String)methodInsn.owner).equals(Class.class.getCanonicalName());
    }
}

