/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.script.OpCode;
import org.objectweb.asm.Label;

public class NeoTryInstruction
extends NeoInstruction {
    private final Label catchOffsetLabel;
    private final Label finallyOffsetLabel;

    public NeoTryInstruction(Label catchOffsetLabel, Label finallyOffsetLabel) {
        super(OpCode.TRY_L, new byte[8]);
        if (catchOffsetLabel == null && finallyOffsetLabel == null) {
            throw new CompilerException("Constructing try instruction without catch offset and without finally offset is illegal. Every try instruction must at least have a catch offset or a finally offset.");
        }
        this.catchOffsetLabel = catchOffsetLabel;
        this.finallyOffsetLabel = finallyOffsetLabel;
    }

    public Label getCatchOffsetLabel() {
        return this.catchOffsetLabel;
    }

    public Label getFinallyOffsetLabel() {
        return this.finallyOffsetLabel;
    }
}

