/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.CompilerException;
import io.neow3j.script.OpCode;
import io.neow3j.script.OperandSize;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.utils.Numeric;
import java.io.IOException;

public class NeoInstruction {
    private OpCode opcode;
    private byte[] operandPrefix;
    private byte[] operand;
    private Object extra;
    private Integer lineNr = null;
    private int address;

    public NeoInstruction(OpCode opcode, byte[] operand) {
        this(opcode, new byte[0], operand);
    }

    public NeoInstruction(OpCode opcode, byte[] operandPrefix, byte[] operand) {
        this.opcode = opcode;
        this.checkOperandSize(operandPrefix, operand);
        this.operandPrefix = operandPrefix;
        this.operand = operand;
    }

    public NeoInstruction(OpCode opcode) {
        this.opcode = opcode;
        this.operandPrefix = new byte[0];
        this.operand = new byte[0];
    }

    public OpCode getOpcode() {
        return this.opcode;
    }

    public byte[] getOperandPrefix() {
        return this.operandPrefix;
    }

    public byte[] getOperand() {
        return this.operand;
    }

    public Integer getLineNr() {
        return this.lineNr;
    }

    public int getAddress() {
        return this.address;
    }

    public Object getExtra() {
        return this.extra;
    }

    public NeoInstruction setExtra(Object extra) {
        this.extra = extra;
        return this;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[1 + this.operandPrefix.length + this.operand.length];
        bytes[0] = (byte)this.opcode.getCode();
        System.arraycopy(this.operandPrefix, 0, bytes, 1, this.operandPrefix.length);
        System.arraycopy(this.operand, 0, bytes, 1 + this.operandPrefix.length, this.operand.length);
        return bytes;
    }

    public int byteSize() {
        return 1 + this.operandPrefix.length + this.operand.length;
    }

    public String toString() {
        return this.opcode.toString() + " " + Numeric.toHexStringNoPrefix((byte[])this.operandPrefix) + " " + Numeric.toHexStringNoPrefix((byte[])this.operand);
    }

    public void setOpcode(OpCode opcode) {
        this.opcode = opcode;
    }

    void setLineNr(Integer lineNr) {
        this.lineNr = lineNr;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setOperand(byte[] operandPrefix, byte[] operand) {
        this.checkOperandSize(operandPrefix, operand);
        this.operandPrefix = operandPrefix;
        this.operand = operand;
    }

    public void setOperand(byte[] operand) {
        this.setOperand(new byte[0], operand);
    }

    private void checkOperandSize(byte[] operandPrefix, byte[] operand) {
        OperandSize operandSize = OpCode.getOperandSize((OpCode)this.opcode);
        if (operandSize == null && (operand == null || operand.length == 0)) {
            return;
        }
        if (operandSize == null && operand != null && operand.length != 0) {
            throw new CompilerException(String.format("Tried to set an operand (%s) on the opcode '%s' which doesn't take any operands.", Numeric.toHexStringNoPrefix((byte[])operand), this.opcode.name()));
        }
        if (operandSize != null && operand == null) {
            throw new CompilerException(String.format("Opcode '%s' requires an operand but no operand was specified.", this.opcode.name()));
        }
        if (operandSize.prefixSize() == 0 && operand.length != operandSize.size()) {
            throw new CompilerException(String.format("Tried to set an operand (%s) with size %d on opcode '%s' which only takes operands of size %d.", Numeric.toHexStringNoPrefix((byte[])operand), operand.length, this.opcode.name(), operandSize.size()));
        }
        if (operandSize.prefixSize() > 0) {
            if (operandSize.prefixSize() != 1 && operandSize.prefixSize() != 2 && operandSize.prefixSize() != 4) {
                throw new CompilerException(String.format("Unexpected operand prefix size. Size was %d but only 1, 2, or 4 are allowed.", operandSize.prefixSize()));
            }
            if (operandPrefix.length != operandSize.prefixSize()) {
                throw new CompilerException(String.format("Opcode '%s' needs an operand prefix of size %d but the given operand prefix is of size %d.", this.opcode.name(), operandSize.prefixSize(), operandPrefix.length));
            }
            BinaryReader reader = new BinaryReader(operandPrefix);
            long specifiedOperandSize = 0L;
            try {
                if (operandSize.prefixSize() == 1) {
                    specifiedOperandSize = reader.readUnsignedByte();
                } else if (operandSize.prefixSize() == 2) {
                    specifiedOperandSize = reader.readUInt16();
                } else if (operandSize.prefixSize() == 4) {
                    specifiedOperandSize = reader.readUInt32();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((long)operand.length != specifiedOperandSize) {
                throw new CompilerException(String.format("Operand prefix specified an operand size of %d but the operand was %d bytes long.", specifiedOperandSize, operand.length));
            }
        }
    }
}

