/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.NeoVariable;
import io.neow3j.script.OpCode;

public class LocalVariableHelper {
    public static void addLoadLocalVariable(int varIndex, NeoMethod neoMethod) {
        LocalVariableHelper.addLoadOrStoreLocalVariable(varIndex, neoMethod, OpCode.LDARG, OpCode.LDLOC);
    }

    public static void addStoreLocalVariable(int varIndex, NeoMethod neoMethod) {
        LocalVariableHelper.addLoadOrStoreLocalVariable(varIndex, neoMethod, OpCode.STARG, OpCode.STLOC);
    }

    private static void addLoadOrStoreLocalVariable(int varIndex, NeoMethod neoMethod, OpCode argOpcode, OpCode varOpcode) {
        if (varIndex >= 255) {
            throw new CompilerException(neoMethod, String.format("The variable index %d is higher than the maximum supported number of local variables %d", varIndex, 255));
        }
        NeoVariable param = neoMethod.getParameterByJVMIndex(varIndex);
        if (param != null) {
            neoMethod.addInstruction(LocalVariableHelper.buildStoreOrLoadVariableInsn(param.getNeoIndex(), argOpcode));
        } else {
            NeoVariable var = neoMethod.getVariableByJVMIndex(varIndex);
            neoMethod.addInstruction(LocalVariableHelper.buildStoreOrLoadVariableInsn(var.getNeoIndex(), varOpcode));
        }
    }

    public static NeoInstruction buildStoreOrLoadVariableInsn(int index, OpCode opcode) {
        NeoInstruction neoInsn;
        if (index <= 6) {
            OpCode storeCode = OpCode.get((int)(opcode.getCode() - 7 + index));
            neoInsn = new NeoInstruction(storeCode);
        } else {
            byte[] operand = new byte[]{(byte)index};
            neoInsn = new NeoInstruction(opcode, operand);
        }
        return neoInsn;
    }
}

