/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.script.OpCode;
import java.io.IOException;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class InitsslotNeoMethod
extends NeoMethod {
    private static final String INITSSLOT_METHOD_NAME = "_initialize";
    private static final String DESIRED_ASSERTION_STATUS = "desiredAssertionStatus";

    public InitsslotNeoMethod(MethodNode asmMethod, ClassNode sourceClass, CompilationUnit compUnit) {
        super(asmMethod, sourceClass);
        this.setName(INITSSLOT_METHOD_NAME);
        this.setIsAbiMethod(true);
        byte[] operand = new byte[]{(byte)this.calcNumberOfContractVariables(sourceClass.fields, compUnit)};
        this.addInstruction(new NeoInstruction(OpCode.INITSSLOT, operand));
    }

    private int calcNumberOfContractVariables(List<FieldNode> fields, CompilationUnit compUnit) {
        return (int)fields.stream().filter(f -> !Compiler.isEvent(f.desc, compUnit)).count();
    }

    protected boolean containsOnlyAssertionRelatedInstructions() {
        AbstractInsnNode insn = this.getAsmMethod().instructions.getFirst().getNext().getNext();
        if (insn.getType() == 9 && insn.getNext().getType() == 5) {
            MethodInsnNode methodInsn = (MethodInsnNode)insn.getNext();
            if (methodInsn.name.equals(DESIRED_ASSERTION_STATUS)) {
                insn = insn.getNext();
                while (!Compiler.isAssertionDisabledStaticField(insn)) {
                    insn = insn.getNext();
                }
                return insn.getNext().getOpcode() == JVMOpcode.RETURN.getOpcode();
            }
        }
        return false;
    }

    @Override
    public void convert(CompilationUnit compUnit) throws IOException {
        for (AbstractInsnNode insn = this.getAsmMethod().instructions.get(0); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() >= JVMOpcode.ISTORE.getOpcode() && insn.getOpcode() <= JVMOpcode.SASTORE.getOpcode()) {
                throw new CompilerException(this, "Local variables are not supported in the static constructor");
            }
            this.throwOnEventConstructorCall(insn, compUnit);
            insn = Compiler.handleInsn(insn, this, compUnit);
        }
        this.insertTryCatchBlocks();
    }

    private void throwOnEventConstructorCall(AbstractInsnNode insn, CompilationUnit compUnit) {
        if (insn instanceof TypeInsnNode) {
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            String desc = Type.getObjectType((String)typeInsn.desc).getDescriptor();
            if (Compiler.isEvent(desc, compUnit)) {
                throw new CompilerException(this, "Events must not be initialized by calling their constructor.");
            }
        }
    }

    @Override
    public void initialize(CompilationUnit compUnit) {
        throw new UnsupportedOperationException("The INITSSLOT method cannotneed to be initialized with local variable and parameter slots.");
    }
}

