/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.DebugInfo;
import io.neow3j.compiler.InitsslotNeoMethod;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.ManifestBuilder;
import io.neow3j.compiler.NeoEvent;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.compiler.converters.ConverterMap;
import io.neow3j.compiler.sourcelookup.ISourceContainer;
import io.neow3j.contract.NefFile;
import io.neow3j.devpack.ByteString;
import io.neow3j.devpack.ECPoint;
import io.neow3j.devpack.Hash160;
import io.neow3j.devpack.Hash256;
import io.neow3j.devpack.InteropInterface;
import io.neow3j.devpack.Iterator;
import io.neow3j.devpack.annotations.ContractSourceCode;
import io.neow3j.devpack.annotations.Instruction;
import io.neow3j.devpack.events.EventInterface;
import io.neow3j.protocol.core.response.ContractManifest;
import io.neow3j.script.InteropService;
import io.neow3j.script.OpCode;
import io.neow3j.script.ScriptBuilder;
import io.neow3j.types.ContractParameterType;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.ClassUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Compiler {
    public static final String COMPILER_NAME = "neow3j-3.17.0";
    public static final int CLASS_VERSION_SUPPORTED = 52;
    public static final int MAX_PARAMS_COUNT = 255;
    public static final int MAX_LOCAL_VARIABLES = 255;
    public static final int MAX_STATIC_FIELDS = 255;
    public static final String INSTANCE_CTOR = "<init>";
    private static final String CLASS_CTOR = "<clinit>";
    public static final String THIS_KEYWORD = "this";
    public static final String INSN_ANNOTATION_OPCODE = "opcode";
    public static final String INSN_ANNOTATION_OPERAND = "operand";
    public static final String INSN_ANNOTATION_OPERAND_PREFIX = "operandPrefix";
    public static final String INSN_ANNOTATION_INTEROPSERVICE = "interopService";
    private static final String ASSERTIONS_DISABLED = "$assertionsDisabled";
    private final CompilationUnit compUnit;

    public Compiler() {
        this.compUnit = new CompilationUnit(this.getClass().getClassLoader());
    }

    public Compiler(ClassLoader classLoader) {
        this.compUnit = new CompilationUnit(classLoader);
    }

    public static ContractParameterType mapTypeToParameterType(Type type) {
        Class<?> clazz2;
        String typeName = type.getClassName();
        if (typeName.equals(String.class.getTypeName())) {
            return ContractParameterType.STRING;
        }
        if (typeName.equals(Integer.class.getTypeName()) || typeName.equals(Integer.TYPE.getTypeName()) || typeName.equals(Long.class.getTypeName()) || typeName.equals(Long.TYPE.getTypeName()) || typeName.equals(Byte.class.getTypeName()) || typeName.equals(Byte.TYPE.getTypeName()) || typeName.equals(Short.class.getTypeName()) || typeName.equals(Short.TYPE.getTypeName()) || typeName.equals(Character.class.getTypeName()) || typeName.equals(Character.TYPE.getTypeName())) {
            return ContractParameterType.INTEGER;
        }
        if (typeName.equals(Boolean.class.getTypeName()) || typeName.equals(Boolean.TYPE.getTypeName())) {
            return ContractParameterType.BOOLEAN;
        }
        if (typeName.equals(Byte[].class.getTypeName()) || typeName.equals(byte[].class.getTypeName()) || typeName.equals(ByteString.class.getTypeName())) {
            return ContractParameterType.BYTE_ARRAY;
        }
        if (typeName.equals(Void.class.getTypeName()) || typeName.equals(Void.TYPE.getTypeName())) {
            return ContractParameterType.VOID;
        }
        if (typeName.equals(ECPoint.class.getTypeName())) {
            return ContractParameterType.PUBLIC_KEY;
        }
        if (typeName.equals(io.neow3j.devpack.Map.class.getTypeName())) {
            return ContractParameterType.MAP;
        }
        if (typeName.equals(Hash160.class.getTypeName())) {
            return ContractParameterType.HASH160;
        }
        if (typeName.equals(Hash256.class.getTypeName())) {
            return ContractParameterType.HASH256;
        }
        if (typeName.equals(io.neow3j.devpack.List.class.getTypeName()) || typeName.equals(Iterator.Struct.class.getTypeName())) {
            return ContractParameterType.ARRAY;
        }
        try {
            typeName = ClassUtils.getFullyQualifiedNameForInternalName((String)type.getInternalName());
            clazz2 = Class.forName(typeName);
            if (Arrays.asList(clazz2.getInterfaces()).contains(InteropInterface.class)) {
                return ContractParameterType.INTEROP_INTERFACE;
            }
        }
        catch (ClassNotFoundException clazz2) {
            // empty catch block
        }
        try {
            typeName = type.getDescriptor().replace("/", ".");
            clazz2 = Class.forName(typeName);
            if (clazz2.isArray()) {
                return ContractParameterType.ARRAY;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ContractParameterType.ANY;
    }

    public static StackItemType mapTypeToStackItemType(Type type) {
        String typeName = type.getClassName();
        if (typeName.equals(String.class.getTypeName()) || typeName.equals(Hash160.class.getTypeName()) || typeName.equals(Hash256.class.getTypeName()) || typeName.equals(ECPoint.class.getTypeName()) || typeName.equals(ByteString.class.getTypeName())) {
            return StackItemType.BYTE_STRING;
        }
        if (typeName.equals(Integer.class.getTypeName()) || typeName.equals(Integer.TYPE.getTypeName()) || typeName.equals(Long.class.getTypeName()) || typeName.equals(Long.TYPE.getTypeName()) || typeName.equals(Byte.class.getTypeName()) || typeName.equals(Byte.TYPE.getTypeName()) || typeName.equals(Short.class.getTypeName()) || typeName.equals(Short.TYPE.getTypeName()) || typeName.equals(Character.class.getTypeName()) || typeName.equals(Character.TYPE.getTypeName())) {
            return StackItemType.INTEGER;
        }
        if (typeName.equals(Boolean.class.getTypeName()) || typeName.equals(Boolean.TYPE.getTypeName())) {
            return StackItemType.BOOLEAN;
        }
        if (typeName.equals(Byte[].class.getTypeName()) || typeName.equals(byte[].class.getTypeName())) {
            return StackItemType.BUFFER;
        }
        if (typeName.equals(io.neow3j.devpack.Map.class.getTypeName())) {
            return StackItemType.MAP;
        }
        if (typeName.equals(io.neow3j.devpack.List.class.getTypeName())) {
            return StackItemType.ARRAY;
        }
        if (typeName.equals(InteropInterface.class.getTypeName())) {
            return StackItemType.INTEROP_INTERFACE;
        }
        if (typeName.equals(Iterator.Struct.class.getTypeName())) {
            return StackItemType.STRUCT;
        }
        try {
            typeName = type.getDescriptor().replace("/", ".");
            Class<?> clazz = Class.forName(typeName);
            if (clazz.isArray()) {
                return StackItemType.ARRAY;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return StackItemType.ANY;
    }

    public CompilationUnit compile(String contractClass, List<ISourceContainer> sourceContainers) throws IOException {
        this.compUnit.addSourceContainers(sourceContainers);
        return this.compile(contractClass);
    }

    public CompilationUnit compile(String contractClass, List<ISourceContainer> sourceContainers, Map<String, String> replaceMap) throws IOException {
        this.compUnit.addSourceContainers(sourceContainers);
        return this.compile(contractClass, replaceMap);
    }

    public CompilationUnit compile(String contractClass) throws IOException {
        return this.compile(AsmHelper.getAsmClass(contractClass, this.compUnit.getClassLoader()));
    }

    public CompilationUnit compile(String contractClass, Map<String, String> replaceMap) throws IOException {
        return this.compile(AsmHelper.getAsmClass(contractClass, this.compUnit.getClassLoader()), replaceMap);
    }

    public CompilationUnit compile(InputStream classStream) throws IOException {
        return this.compile(AsmHelper.getAsmClass(classStream));
    }

    public CompilationUnit compile(InputStream classStream, Map<String, String> replaceMap) throws IOException {
        return this.compile(AsmHelper.getAsmClass(classStream), replaceMap);
    }

    protected CompilationUnit compile(ClassNode classNode, Map<String, String> replaceMap) throws IOException {
        Compiler.substitutePlaceholdersInMethodBodies(classNode, replaceMap);
        Compiler.substitutePlaceholdersInAnnotations(classNode, replaceMap);
        return this.compile(classNode);
    }

    private static void substitutePlaceholdersInMethodBodies(ClassNode classNode, Map<String, String> replaceMap) {
        classNode.methods.forEach(methodNode -> {
            for (AbstractInsnNode insnNode : methodNode.instructions) {
                if (insnNode.getType() != 9) continue;
                LdcInsnNode node = (LdcInsnNode)insnNode;
                if (!(node.cst instanceof String) || !replaceMap.containsKey(node.cst)) continue;
                node.cst = replaceMap.get(node.cst);
            }
        });
    }

    private static void substitutePlaceholdersInAnnotations(ClassNode classNode, Map<String, String> replaceMap) {
        ArrayList annotations = new ArrayList();
        if (classNode.invisibleAnnotations != null) {
            annotations.addAll(classNode.invisibleAnnotations);
        }
        annotations.addAll(classNode.fields.stream().filter(f -> f.invisibleAnnotations != null).flatMap(f -> f.invisibleAnnotations.stream()).collect(Collectors.toList()));
        annotations.addAll(classNode.methods.stream().filter(m -> m.invisibleAnnotations != null).flatMap(m -> m.invisibleAnnotations.stream()).collect(Collectors.toList()));
        annotations.forEach(it -> Compiler.processAnnotationNode(it, replaceMap));
    }

    private static void processAnnotationNode(AnnotationNode annotationNode, Map<String, String> replaceMap) {
        if (annotationNode.values == null || annotationNode.values.size() % 2 != 0) {
            return;
        }
        for (int i = 0; i < annotationNode.values.size(); i += 2) {
            Object value = annotationNode.values.get(i + 1);
            if (value == null) continue;
            if (value instanceof String) {
                if (!replaceMap.containsKey(value)) continue;
                annotationNode.values.set(i + 1, replaceMap.get(value));
                continue;
            }
            if (value instanceof AnnotationNode) {
                Compiler.processAnnotationNode((AnnotationNode)value, replaceMap);
                continue;
            }
            if (!(value instanceof List)) continue;
            List casted = (List)value;
            for (int j = 0; j < casted.size(); ++j) {
                Object elem = casted.get(j);
                if (elem instanceof String) {
                    if (!replaceMap.containsKey(elem)) continue;
                    casted.set(j, replaceMap.get(elem));
                    continue;
                }
                if (!(elem instanceof AnnotationNode)) continue;
                Compiler.processAnnotationNode((AnnotationNode)elem, replaceMap);
            }
        }
    }

    protected CompilationUnit compile(ClassNode classNode) throws IOException {
        this.checkForClassCompatibility(classNode);
        this.checkForUsageOfInstanceConstructor(classNode);
        this.checkForNonStaticVariablesOnContractClass(classNode);
        this.compUnit.setContractClass(classNode);
        this.collectSmartContractEvents(classNode);
        List<NeoMethod> initializedNeoMethods = this.initializeContractMethods(classNode);
        this.compUnit.getNeoModule().addMethods(initializedNeoMethods);
        ArrayList<NeoMethod> neoMethods = new ArrayList<NeoMethod>(this.compUnit.getNeoModule().getSortedMethods());
        for (NeoMethod neoMethod : neoMethods) {
            neoMethod.convert(this.compUnit);
        }
        this.compileInitsslotMethod();
        this.finalizeCompilation();
        return this.compUnit;
    }

    public static boolean isAssertionDisabledStaticField(AbstractInsnNode insn) {
        if (insn.getType() != 4) {
            return false;
        }
        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
        return fieldInsn.name.equals(ASSERTIONS_DISABLED);
    }

    private void checkForNonStaticVariablesOnContractClass(ClassNode contractClass) {
        if (contractClass.fields.stream().anyMatch(f -> (f.access & 8) == 0)) {
            throw new CompilerException(String.format("Contract class %s has non-static fields but only static fields are supported in smart contract classes.", ClassUtils.getFullyQualifiedNameForInternalName((String)contractClass.name)));
        }
    }

    private void compileInitsslotMethod() throws IOException {
        Optional<MethodNode> classCtorOpt = this.compUnit.getContractClass().methods.stream().filter(m -> m.name.equals(CLASS_CTOR)).findFirst();
        if (!classCtorOpt.isPresent()) {
            return;
        }
        InitsslotNeoMethod m2 = new InitsslotNeoMethod(classCtorOpt.get(), this.compUnit.getContractClass(), this.compUnit);
        if (m2.containsOnlyAssertionRelatedInstructions()) {
            return;
        }
        this.compUnit.getNeoModule().addMethod(m2);
        m2.convert(this.compUnit);
    }

    private void finalizeCompilation() {
        this.compUnit.getNeoModule().finalizeModule();
        String sourceUrl = this.getSourceUrl(this.compUnit.getContractClass());
        NefFile nef = new NefFile(COMPILER_NAME, sourceUrl, this.compUnit.getNeoModule().getMethodTokens(), this.compUnit.getNeoModule().toByteArray());
        ContractManifest manifest = ManifestBuilder.buildManifest(this.compUnit);
        this.compUnit.setNef(nef);
        this.compUnit.setManifest(manifest);
        this.compUnit.setDebugInfo(DebugInfo.buildDebugInfo(this.compUnit));
    }

    private String getSourceUrl(ClassNode contractClass) {
        Optional<AnnotationNode> a = AsmHelper.getAnnotationNode(contractClass, ContractSourceCode.class);
        return a.map(annotationNode -> (String)annotationNode.values.get(1)).orElse(null);
    }

    private void collectSmartContractEvents(ClassNode asmClass) {
        if (asmClass.fields == null || asmClass.fields.size() == 0) {
            return;
        }
        List<FieldNode> eventFields = asmClass.fields.stream().filter(field -> Compiler.isEvent(field.desc, this.compUnit)).collect(Collectors.toList());
        if (eventFields.size() == 0) {
            return;
        }
        eventFields.forEach(f -> this.compUnit.getNeoModule().addEvent(new NeoEvent((FieldNode)f, asmClass)));
    }

    private void checkForUsageOfInstanceConstructor(ClassNode asmClass) {
        Optional<MethodNode> instanceCtor = asmClass.methods.stream().filter(m -> m.name.equals(INSTANCE_CTOR)).findFirst();
        if (instanceCtor.isPresent()) {
            MethodInsnNode insn = Compiler.skipToSuperCtorCall(instanceCtor.get(), asmClass);
            for (insn = insn.getNext(); insn != null; insn = insn.getNext()) {
                if (insn.getType() == 15 || insn.getType() == 8 || insn.getType() == 14 || insn.getOpcode() == JVMOpcode.RETURN.getOpcode()) continue;
                throw new CompilerException(String.format("Class %s has an explicit instance constructor, which is not supported.", ClassUtils.getFullyQualifiedNameForInternalName((String)asmClass.name)));
            }
        }
    }

    private void checkForClassCompatibility(ClassNode asmClass) {
        if (asmClass.version != 52) {
            throw new CompilerException(String.format("Class %s was compiled with JVM version %d, which is not supported. Please, change your environment to compile the class to version %d.", ClassUtils.getFullyQualifiedNameForInternalName((String)asmClass.name), asmClass.version, 52));
        }
    }

    private List<NeoMethod> initializeContractMethods(ClassNode asmClass) {
        ArrayList<NeoMethod> methods = new ArrayList<NeoMethod>();
        for (MethodNode asmMethod : asmClass.methods) {
            if (asmMethod.name.equals(INSTANCE_CTOR) || asmMethod.name.equals(CLASS_CTOR)) continue;
            if ((asmMethod.access & 8) == 0) {
                throw new CompilerException(asmClass, String.format("Method '%s' of class %s is non-static but only static methods are allowed in smart contracts.", asmMethod.name, ClassUtils.getFullyQualifiedNameForInternalName((String)asmClass.name)));
            }
            if (this.compUnit.getNeoModule().hasMethod(NeoMethod.getMethodId(asmMethod, asmClass))) continue;
            NeoMethod neoMethod = new NeoMethod(asmMethod, asmClass);
            neoMethod.initialize(this.compUnit);
            methods.add(neoMethod);
        }
        return methods;
    }

    public static AbstractInsnNode handleInsn(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        JVMOpcode opcode;
        if (insn.getType() == 15) {
            neoMethod.setCurrentLine(((LineNumberNode)insn).line);
        }
        if (insn.getType() == 8) {
            neoMethod.setCurrentLabel(((LabelNode)insn).getLabel());
        }
        if (insn.getType() == 5) {
            Compiler.throwIfObjectIsOwner((MethodInsnNode)insn);
        }
        if ((opcode = JVMOpcode.get(insn.getOpcode())) == null) {
            return insn;
        }
        Converter converter = ConverterMap.get(opcode);
        if (converter == null) {
            throw new CompilerException(neoMethod, String.format("Unsupported instruction %s in method '%s' of class %s", opcode.toString(), neoMethod.getSourceMethodName(), ClassUtils.getFullyQualifiedNameForInternalName((String)neoMethod.getOwnerClass().name)));
        }
        return converter.convert(insn, neoMethod, compUnit);
    }

    private static void throwIfObjectIsOwner(MethodInsnNode insn) {
        if (ClassUtils.getFullyQualifiedNameForInternalName((String)insn.owner).equals(Object.class.getCanonicalName())) {
            throw new CompilerException("Inherited methods that are not specifically implemented are not supported. Implement the method '" + insn.name + "' without a 'super' call to the class Object to use it.");
        }
    }

    public static void processInstructionAnnotations(MethodNode callee, NeoMethod caller) {
        List<AnnotationNode> nodes = AsmHelper.getAnnotations(callee, Instruction.class, Instruction.Instructions.class);
        if (Compiler.isSingleSyscallInstruction(nodes)) {
            int paramsCount = Type.getMethodType((String)callee.desc).getArgumentTypes().length;
            if ((callee.access & 8) == 0 && !callee.name.equals(INSTANCE_CTOR)) {
                ++paramsCount;
            }
            Compiler.addReverseArguments(caller, paramsCount);
        }
        nodes.forEach(a -> Compiler.addInstruction(a, caller));
    }

    private static boolean isSingleSyscallInstruction(List<AnnotationNode> annotations) {
        if (annotations.size() != 1) {
            return false;
        }
        String name = AsmHelper.getStringAnnotationProperty(annotations.get(0), INSN_ANNOTATION_INTEROPSERVICE);
        return name != null && !InteropService.valueOf((String)name).equals((Object)InteropService.DUMMY);
    }

    public static void addReverseArguments(MethodNode calledAsmMethod, NeoMethod callingNeoMethod) {
        int paramsCount = Type.getMethodType((String)calledAsmMethod.desc).getArgumentTypes().length;
        if ((calledAsmMethod.access & 8) == 0) {
            ++paramsCount;
        }
        Compiler.addReverseArguments(callingNeoMethod, paramsCount);
    }

    public static void addReverseArguments(NeoMethod callingNeoMethod, int paramsCount) {
        if (paramsCount == 2) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.SWAP));
        } else if (paramsCount == 3) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.REVERSE3));
        } else if (paramsCount == 4) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.REVERSE4));
        } else if (paramsCount > 4) {
            Compiler.addPushNumber(paramsCount, callingNeoMethod);
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.REVERSEN));
        }
    }

    private static void addInstruction(AnnotationNode annotation, NeoMethod neoMethod) {
        InteropService interopService;
        if (annotation.values == null) {
            return;
        }
        String name = AsmHelper.getStringAnnotationProperty(annotation, INSN_ANNOTATION_INTEROPSERVICE);
        if (name != null && !(interopService = InteropService.valueOf((String)name)).equals((Object)InteropService.DUMMY)) {
            byte[] hash = Numeric.hexStringToByteArray((String)interopService.getHash());
            neoMethod.addInstruction(new NeoInstruction(OpCode.SYSCALL, hash));
            return;
        }
        String opcodeName = AsmHelper.getStringAnnotationProperty(annotation, INSN_ANNOTATION_OPCODE);
        OpCode opcode = OpCode.valueOf((String)opcodeName);
        if (opcode.equals((Object)OpCode.NOP)) {
            return;
        }
        byte[] operandPrefix = new byte[]{};
        if (annotation.values.contains(INSN_ANNOTATION_OPERAND_PREFIX)) {
            operandPrefix = AsmHelper.getByteArrayAnnotationProperty(annotation, INSN_ANNOTATION_OPERAND_PREFIX);
        }
        byte[] operand = new byte[]{};
        if (annotation.values.contains(INSN_ANNOTATION_OPERAND)) {
            operand = AsmHelper.getByteArrayAnnotationProperty(annotation, INSN_ANNOTATION_OPERAND);
        }
        neoMethod.addInstruction(new NeoInstruction(opcode, operandPrefix, operand));
    }

    public static void addLoadConstant(AbstractInsnNode insn, NeoMethod neoMethod) {
        LdcInsnNode ldcInsn = (LdcInsnNode)insn;
        if (ldcInsn.cst instanceof String) {
            byte[] data = ((String)ldcInsn.cst).getBytes(StandardCharsets.UTF_8);
            neoMethod.addInstruction(Compiler.buildPushDataInsn(data));
        } else if (ldcInsn.cst instanceof Integer) {
            Compiler.addPushNumber(((Integer)ldcInsn.cst).intValue(), neoMethod);
        } else if (ldcInsn.cst instanceof Long) {
            Compiler.addPushNumber((Long)ldcInsn.cst, neoMethod);
        } else if (ldcInsn.cst instanceof Float || ldcInsn.cst instanceof Double) {
            throw new CompilerException(neoMethod, "Found use of float number but the compiler does not support floats.");
        }
    }

    public static NeoInstruction buildPushDataInsn(byte[] data) {
        return Compiler.buildPushDataInsnFromInsnBytes(new ScriptBuilder().pushData(data).toArray());
    }

    public static NeoInstruction buildPushDataInsn(String data) {
        return Compiler.buildPushDataInsnFromInsnBytes(new ScriptBuilder().pushData(data).toArray());
    }

    private static NeoInstruction buildPushDataInsnFromInsnBytes(byte[] insnBytes) {
        OpCode opcode = OpCode.get((byte)insnBytes[0]);
        int prefixSize = OpCode.getOperandSize((OpCode)opcode).prefixSize();
        byte[] operandPrefix = Arrays.copyOfRange(insnBytes, 1, 1 + prefixSize);
        byte[] operand = Arrays.copyOfRange(insnBytes, 1 + prefixSize, insnBytes.length);
        return new NeoInstruction(opcode, operandPrefix, operand);
    }

    public static MethodInsnNode skipToSuperCtorCall(MethodNode constructor, ClassNode owner) {
        ListIterator it = constructor.instructions.iterator();
        AbstractInsnNode insn = null;
        while (it.hasNext() && !Compiler.isCallToCtor(insn = (AbstractInsnNode)it.next(), owner.superName)) {
        }
        assert (insn != null && insn.getType() == 5) : "Expected call to constructor but couldn't find it.";
        return (MethodInsnNode)insn;
    }

    public static MethodInsnNode skipToCtorCall(AbstractInsnNode insn, ClassNode owner) {
        while (insn != null && !Compiler.isCallToCtor(insn = insn.getNext(), owner.name)) {
        }
        assert (insn != null && insn.getType() == 5) : "Expected call to constructor but couldn't find it.";
        return (MethodInsnNode)insn;
    }

    public static boolean isCallToCtor(AbstractInsnNode insn, String ownerInternalName) {
        return insn.getType() == 5 && ((MethodInsnNode)insn).owner.equals(ownerInternalName) && ((MethodInsnNode)insn).name.equals(INSTANCE_CTOR);
    }

    public static void addPushNumber(long number, NeoMethod neoMethod) {
        neoMethod.addInstruction(Compiler.buildPushNumberInstruction(BigInteger.valueOf(number)));
    }

    public static NeoInstruction buildPushNumberInstruction(BigInteger number) {
        byte[] insnBytes = new ScriptBuilder().pushInteger(number).toArray();
        byte[] operand = Arrays.copyOfRange(insnBytes, 1, insnBytes.length);
        return new NeoInstruction(OpCode.get((byte)insnBytes[0]), operand);
    }

    public static boolean isEvent(String classDesc, CompilationUnit compUnit) {
        char firstChar = classDesc.charAt(0);
        if (AsmHelper.PRIMITIVE_TYPE_NAMES.contains(Character.valueOf(firstChar)) || firstChar == '[') {
            return false;
        }
        try {
            return AsmHelper.getAsmClassForDescriptor((String)classDesc, (ClassLoader)compUnit.getClassLoader()).interfaces.stream().map(ClassUtils::getFullyQualifiedNameForInternalName).anyMatch(i -> i.equals(EventInterface.class.getName()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed fetching class " + classDesc, e);
        }
    }
}

