/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.DebugInfo;
import io.neow3j.compiler.NeoModule;
import io.neow3j.compiler.sourcelookup.ISourceContainer;
import io.neow3j.contract.NefFile;
import io.neow3j.protocol.core.response.ContractManifest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.ClassNode;

public class CompilationUnit {
    private ClassLoader classLoader;
    private final NeoModule neoModule;
    private NefFile nef;
    private ContractManifest manifest;
    private DebugInfo debugInfo;
    private ClassNode contractClass;
    private final Map<String, File> sourceFileMap = new HashMap<String, File>();
    private final List<ISourceContainer> sourceContainers = new ArrayList<ISourceContainer>();

    public CompilationUnit(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.neoModule = new NeoModule();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public NeoModule getNeoModule() {
        return this.neoModule;
    }

    public NefFile getNefFile() {
        return this.nef;
    }

    public ContractManifest getManifest() {
        return this.manifest;
    }

    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void setNef(NefFile nef) {
        this.nef = nef;
    }

    protected void setManifest(ContractManifest manifest) {
        this.manifest = manifest;
    }

    protected void setDebugInfo(DebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    protected void setContractClass(ClassNode classNode) {
        this.contractClass = classNode;
    }

    protected ClassNode getContractClass() {
        return this.contractClass;
    }

    protected File getSourceFile(ClassNode classNode) {
        if (this.sourceFileMap.containsKey(classNode.name)) {
            return this.sourceFileMap.get(classNode.name);
        }
        String filePath = this.extractFilePathWithPackage(classNode);
        for (ISourceContainer container : this.sourceContainers) {
            File sourceFile = container.findSourceFile(filePath);
            if (sourceFile == null) continue;
            this.sourceFileMap.put(classNode.name, sourceFile);
            return sourceFile;
        }
        this.sourceFileMap.put(classNode.name, null);
        return null;
    }

    private String extractFilePathWithPackage(ClassNode classNode) {
        int idx = classNode.name.lastIndexOf(47);
        String packageName = classNode.name.substring(0, idx + 1);
        String sourceFileName = classNode.sourceFile;
        if (!classNode.sourceFile.contains(".java")) {
            sourceFileName = sourceFileName + ".java";
        }
        return (packageName + sourceFileName).replace('/', File.separatorChar);
    }

    public void addSourceContainers(List<ISourceContainer> sourceContainers) {
        this.sourceContainers.addAll(sourceContainers);
    }
}

