/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountKeyLinkTransaction;
import io.nem.symbol.sdk.model.transaction.AccountKeyLinkTransactionFactory;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountKeyLinkTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.LinkActionEnum;

class AccountKeyLinkTransactionMapper
extends AbstractTransactionMapper<AccountKeyLinkTransactionDTO, AccountKeyLinkTransaction> {
    public AccountKeyLinkTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_KEY_LINK, AccountKeyLinkTransactionDTO.class);
    }

    protected AccountKeyLinkTransactionFactory createFactory(NetworkType networkType, Deadline deadline, AccountKeyLinkTransactionDTO dto) {
        PublicKey linkedPublicKey = PublicKey.fromHexString((String)dto.getLinkedPublicKey());
        return AccountKeyLinkTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (PublicKey)linkedPublicKey, (LinkAction)LinkAction.rawValueOf((int)dto.getLinkAction().getValue()));
    }

    @Override
    protected void copyToDto(AccountKeyLinkTransaction transaction, AccountKeyLinkTransactionDTO dto) {
        dto.setLinkedPublicKey(transaction.getLinkedPublicKey().toHex());
        dto.setLinkAction(LinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
    }
}

