/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountAddressRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountAddressRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.AccountAddressRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountAddressRestrictionTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionFlagsEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountAddressRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountAddressRestrictionTransactionDTO, AccountAddressRestrictionTransaction> {
    public AccountAddressRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_ADDRESS_RESTRICTION, AccountAddressRestrictionTransactionDTO.class);
    }

    protected AccountAddressRestrictionTransactionFactory createFactory(NetworkType networkType, Deadline deadline, AccountAddressRestrictionTransactionDTO transaction) {
        AccountAddressRestrictionFlags restrictionFlags = AccountAddressRestrictionFlags.rawValueOf((int)transaction.getRestrictionFlags().getValue());
        List restrictionAdditions = transaction.getRestrictionAdditions().stream().map(MapperUtils::toUnresolvedAddress).collect(Collectors.toList());
        List restrictionDeletions = transaction.getRestrictionDeletions().stream().map(MapperUtils::toUnresolvedAddress).collect(Collectors.toList());
        return AccountAddressRestrictionTransactionFactory.create((NetworkType)networkType, (Deadline)deadline, (AccountAddressRestrictionFlags)restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    @Override
    protected void copyToDto(AccountAddressRestrictionTransaction transaction, AccountAddressRestrictionTransactionDTO dto) {
        dto.setRestrictionFlags(AccountRestrictionFlagsEnum.fromValue((Integer)transaction.getRestrictionFlags().getValue()));
        dto.setRestrictionAdditions(transaction.getRestrictionAdditions().stream().map(r -> r.encoded(transaction.getNetworkType())).collect(Collectors.toList()));
        dto.setRestrictionDeletions(transaction.getRestrictionDeletions().stream().map(r -> r.encoded(transaction.getNetworkType())).collect(Collectors.toList()));
    }
}

