/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.api.SecretLockRepository;
import io.nem.symbol.sdk.api.SecretLockSearchCriteria;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.transaction.LockHashAlgorithm;
import io.nem.symbol.sdk.model.transaction.LockStatus;
import io.nem.symbol.sdk.model.transaction.SecretLockInfo;
import io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockEntryDTO;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockPage;
import io.reactivex.Observable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class SecretLockRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements SecretLockRepository {
    private final SecretLockRoutesApi client;

    public SecretLockRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new SecretLockRoutesApiImpl(apiClient);
    }

    private SecretLockInfo toSecretLockInfo(SecretLockInfoDTO dto) {
        SecretLockEntryDTO lock = dto.getLock();
        MosaicId mosaicId = MapperUtils.toMosaicId((String)lock.getMosaicId());
        return new SecretLockInfo(dto.getId(), ((Integer)ObjectUtils.defaultIfNull((Object)lock.getVersion(), (Object)1)).intValue(), MapperUtils.toAddress((String)lock.getOwnerAddress()), mosaicId, lock.getAmount(), lock.getEndHeight(), LockStatus.rawValueOf((byte)lock.getStatus().getValue().byteValue()), LockHashAlgorithm.rawValueOf((int)lock.getHashAlgorithm().getValue()), lock.getSecret(), MapperUtils.toAddress((String)lock.getRecipientAddress()), lock.getCompositeHash());
    }

    public Observable<Page<SecretLockInfo>> search(SecretLockSearchCriteria criteria) {
        String address = this.toDto(criteria.getAddress());
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        String secret = criteria.getSecret();
        Order order = this.toDto(criteria.getOrder());
        Consumer handlerConsumer = h -> this.getClient().searchSecretLock(address, secret, pageSize, pageNumber, offset, order, h);
        return this.call(handlerConsumer, this::toPage);
    }

    private Page<SecretLockInfo> toPage(SecretLockPage SecretLockPage2) {
        return this.toPage(SecretLockPage2.getPagination(), SecretLockPage2.getData().stream().map(this::toSecretLockInfo).collect(Collectors.toList()));
    }

    public SecretLockRoutesApi getClient() {
        return this.client;
    }

    public Observable<SecretLockInfo> getSecretLock(String compositeHash) {
        return this.call(h -> this.getClient().getSecretLock(compositeHash, h), this::toSecretLockInfo);
    }

    public Observable<MerkleStateInfo> getSecretLockMerkle(String compositeHash) {
        return this.call(h -> this.getClient().getSecretLockMerkle(compositeHash, h), this::toMerkleStateInfo);
    }
}

