/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.MultisigRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.MultisigAccountGraphInfo;
import io.nem.symbol.sdk.model.account.MultisigAccountInfo;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountGraphInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigDTO;
import io.reactivex.Observable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class MultisigRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements MultisigRepository {
    private final MultisigRoutesApi client;

    public MultisigRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new MultisigRoutesApiImpl(apiClient);
    }

    public Observable<MultisigAccountInfo> getMultisigAccountInfo(Address address) {
        return this.call(handler -> this.getClient().getAccountMultisig(address.plain(), handler), this::toMultisigAccountInfo);
    }

    public Observable<MerkleStateInfo> getMultisigAccountInfoMerkle(Address address) {
        return this.call(h -> this.getClient().getAccountMultisigMerkle(address.plain(), h), this::toMerkleStateInfo);
    }

    public Observable<MultisigAccountGraphInfo> getMultisigAccountGraphInfo(Address address) {
        return this.call(handler -> this.getClient().getAccountMultisigGraph(address.plain(), handler), multisigAccountGraphInfoDTOList -> {
            HashMap multisigAccountInfoMap = new HashMap();
            multisigAccountGraphInfoDTOList.forEach(item -> multisigAccountInfoMap.put(item.getLevel(), this.toMultisigAccountInfo((MultisigAccountGraphInfoDTO)item)));
            return new MultisigAccountGraphInfo(multisigAccountInfoMap);
        });
    }

    private List<MultisigAccountInfo> toMultisigAccountInfo(MultisigAccountGraphInfoDTO item) {
        return item.getMultisigEntries().stream().map(this::toMultisigAccountInfo).collect(Collectors.toList());
    }

    private MultisigAccountInfo toMultisigAccountInfo(MultisigAccountInfoDTO info) {
        MultisigDTO dto = info.getMultisig();
        return new MultisigAccountInfo(null, ((Integer)ObjectUtils.defaultIfNull((Object)info.getMultisig().getVersion(), (Object)1)).intValue(), MapperUtils.toAddress((String)dto.getAccountAddress()), dto.getMinApproval().longValue(), dto.getMinRemoval().longValue(), dto.getCosignatoryAddresses().stream().map(MapperUtils::toAddress).collect(Collectors.toList()), dto.getMultisigAddresses().stream().map(MapperUtils::toAddress).collect(Collectors.toList()));
    }

    public MultisigRoutesApi getClient() {
        return this.client;
    }
}

