/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.MosaicRepository;
import io.nem.symbol.sdk.api.MosaicSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.mosaic.MosaicFlags;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicInfo;
import io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.reactivex.Observable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class MosaicRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements MosaicRepository {
    private final MosaicRoutesApi client;

    public MosaicRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new MosaicRoutesApiImpl(apiClient);
    }

    public MosaicRoutesApi getClient() {
        return this.client;
    }

    public Observable<MosaicInfo> getMosaic(MosaicId mosaicId) {
        Consumer callback = handler -> this.getClient().getMosaic(mosaicId.getIdAsHex(), handler);
        return this.call(callback).map(this::createMosaicInfo);
    }

    public Observable<MerkleStateInfo> getMosaicMerkle(MosaicId mosaicId) {
        return this.call(h -> this.getClient().getMosaicMerkle(mosaicId.getIdAsHex(), h), this::toMerkleStateInfo);
    }

    public Observable<List<MosaicInfo>> getMosaics(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getMosaics(mosaicIds, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::createMosaicInfo).toList().toObservable());
    }

    public Observable<Page<MosaicInfo>> search(MosaicSearchCriteria criteria) {
        Consumer callback = handler -> this.getClient().searchMosaics(this.toDto(criteria.getOwnerAddress()), criteria.getPageSize(), criteria.getPageNumber(), criteria.getOffset(), this.toDto(criteria.getOrder()), handler);
        return this.exceptionHandling(this.call(callback).map(mosaicPage -> this.toPage(mosaicPage.getPagination(), mosaicPage.getData().stream().map(this::createMosaicInfo).collect(Collectors.toList()))));
    }

    private MosaicInfo createMosaicInfo(MosaicInfoDTO mosaicInfoDTO) {
        return this.createMosaicInfo(mosaicInfoDTO.getMosaic(), mosaicInfoDTO.getId());
    }

    private MosaicInfo createMosaicInfo(MosaicDTO mosaic, String recordId) {
        return new MosaicInfo(recordId, ((Integer)ObjectUtils.defaultIfNull((Object)mosaic.getVersion(), (Object)1)).intValue(), MapperUtils.toMosaicId((String)mosaic.getId()), mosaic.getSupply(), mosaic.getStartHeight(), MapperUtils.toAddress((String)mosaic.getOwnerAddress()), mosaic.getRevision().longValue(), MosaicRepositoryVertxImpl.extractMosaicFlags(mosaic), mosaic.getDivisibility().intValue(), mosaic.getDuration());
    }

    private static MosaicFlags extractMosaicFlags(MosaicDTO mosaicDTO) {
        return MosaicFlags.create((int)mosaicDTO.getFlags());
    }
}

