/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.HashLockRepository;
import io.nem.symbol.sdk.api.HashLockSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.transaction.HashLockInfo;
import io.nem.symbol.sdk.model.transaction.LockStatus;
import io.nem.symbol.sdk.openapi.vertx.api.HashLockRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.HashLockRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockEntryDTO;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockPage;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.reactivex.Observable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class HashLockRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements HashLockRepository {
    private final HashLockRoutesApi client;

    public HashLockRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new HashLockRoutesApiImpl(apiClient);
    }

    public Observable<HashLockInfo> getHashLock(String hash) {
        return this.call(h -> this.getClient().getHashLock(hash, h), this::toHashLockInfo);
    }

    public Observable<MerkleStateInfo> getHashLockMerkle(String hash) {
        return this.call(h -> this.getClient().getHashLockMerkle(hash, h), this::toMerkleStateInfo);
    }

    private HashLockInfo toHashLockInfo(HashLockInfoDTO dto) {
        HashLockEntryDTO lock = dto.getLock();
        return new HashLockInfo(dto.getId(), ((Integer)ObjectUtils.defaultIfNull((Object)dto.getLock().getVersion(), (Object)1)).intValue(), MapperUtils.toAddress((String)lock.getOwnerAddress()), MapperUtils.toMosaicId((String)lock.getMosaicId()), lock.getAmount(), lock.getEndHeight(), LockStatus.rawValueOf((byte)lock.getStatus().getValue().byteValue()), lock.getHash());
    }

    public Observable<Page<HashLockInfo>> search(HashLockSearchCriteria criteria) {
        String address = this.toDto(criteria.getAddress());
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        Consumer handlerConsumer = h -> this.getClient().searchHashLock(address, pageSize, pageNumber, offset, order, h);
        return this.call(handlerConsumer, this::toPage);
    }

    private Page<HashLockInfo> toPage(HashLockPage hashLockPage) {
        return this.toPage(hashLockPage.getPagination(), hashLockPage.getData().stream().map(this::toHashLockInfo).collect(Collectors.toList()));
    }

    public HashLockRoutesApi getClient() {
        return this.client;
    }
}

