/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.VrfKeyLinkTransaction;
import org.apache.commons.lang3.Validate;

public class VrfKeyLinkTransactionFactory
extends TransactionFactory<VrfKeyLinkTransaction> {
    private final PublicKey linkedPublicKey;
    private final LinkAction linkAction;

    public VrfKeyLinkTransactionFactory(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, LinkAction linkAction) {
        super(TransactionType.VRF_KEY_LINK, networkType, deadline);
        Validate.notNull((Object)linkedPublicKey, (String)"linkedPublicKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)linkAction), (String)"linkAction must not be null", (Object[])new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.linkAction = linkAction;
    }

    public static VrfKeyLinkTransactionFactory create(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, LinkAction linkAction) {
        return new VrfKeyLinkTransactionFactory(networkType, deadline, linkedPublicKey, linkAction);
    }

    @Override
    public VrfKeyLinkTransaction build() {
        return new VrfKeyLinkTransaction(this);
    }

    public PublicKey getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkAction getLinkAction() {
        return this.linkAction;
    }
}

