/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.VotingKeyLinkTransaction;
import org.apache.commons.lang3.Validate;

public class VotingKeyLinkTransactionFactory
extends TransactionFactory<VotingKeyLinkTransaction> {
    private final PublicKey linkedPublicKey;
    private final long startEpoch;
    private final long endEpoch;
    private final LinkAction linkAction;

    private VotingKeyLinkTransactionFactory(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, long startEpoch, long endEpoch, LinkAction linkAction) {
        super(TransactionType.VOTING_KEY_LINK, networkType, deadline);
        Validate.notNull((Object)linkedPublicKey, (String)"linkedPublicKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)linkAction), (String)"linkAction must not be null", (Object[])new Object[0]);
        ConvertUtils.validateNotNegative(startEpoch);
        ConvertUtils.validateNotNegative(endEpoch);
        this.linkedPublicKey = linkedPublicKey;
        this.startEpoch = startEpoch;
        this.endEpoch = endEpoch;
        this.linkAction = linkAction;
    }

    public static VotingKeyLinkTransactionFactory create(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, long startEpoch, long endEpoch, LinkAction linkAction) {
        return new VotingKeyLinkTransactionFactory(networkType, deadline, linkedPublicKey, startEpoch, endEpoch, linkAction);
    }

    @Override
    public VotingKeyLinkTransaction build() {
        return new VotingKeyLinkTransaction(this);
    }

    public PublicKey getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkAction getLinkAction() {
        return this.linkAction;
    }

    public long getStartEpoch() {
        return this.startEpoch;
    }

    public long getEndEpoch() {
        return this.endEpoch;
    }
}

