/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.message.Message;
import io.nem.symbol.sdk.model.message.PersistentHarvestingDelegationMessage;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.TransferTransaction;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class TransferTransactionFactory
extends TransactionFactory<TransferTransaction> {
    private final UnresolvedAddress recipient;
    private final List<Mosaic> mosaics;
    private Message message;

    private TransferTransactionFactory(NetworkType networkType, Deadline deadline, UnresolvedAddress recipient, List<Mosaic> mosaics) {
        super(TransactionType.TRANSFER, networkType, deadline);
        Validate.notNull((Object)recipient, (String)"Recipient must not be null", (Object[])new Object[0]);
        Validate.notNull(mosaics, (String)"Mosaics must not be null", (Object[])new Object[0]);
        this.recipient = recipient;
        this.mosaics = mosaics;
    }

    public static TransferTransactionFactory create(NetworkType networkType, Deadline deadline, UnresolvedAddress recipient, List<Mosaic> mosaics) {
        return new TransferTransactionFactory(networkType, deadline, recipient, mosaics);
    }

    public static TransferTransactionFactory createPersistentDelegationRequestTransaction(NetworkType networkType, Deadline deadline, PrivateKey signingPrivateKey, PrivateKey vrfPrivateKey, PublicKey nodePublicKey) {
        PersistentHarvestingDelegationMessage message = PersistentHarvestingDelegationMessage.create(signingPrivateKey, vrfPrivateKey, nodePublicKey);
        return new TransferTransactionFactory(networkType, deadline, Address.createFromPublicKey(nodePublicKey.toHex(), networkType), Collections.emptyList()).message(message);
    }

    public UnresolvedAddress getRecipient() {
        return this.recipient;
    }

    public List<Mosaic> getMosaics() {
        return this.mosaics;
    }

    public Message getMessage() {
        return this.message;
    }

    public TransferTransactionFactory message(Message message) {
        this.message = message;
        return this;
    }

    @Override
    public TransferTransaction build() {
        return new TransferTransaction(this);
    }
}

