/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.message.Message;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.transaction.RecipientTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransferTransactionFactory;
import java.util.List;
import java.util.Optional;

public class TransferTransaction
extends Transaction
implements RecipientTransaction {
    private final UnresolvedAddress recipient;
    private final List<Mosaic> mosaics;
    private final Message message;

    TransferTransaction(TransferTransactionFactory factory) {
        super(factory);
        this.recipient = factory.getRecipient();
        this.mosaics = factory.getMosaics();
        this.message = factory.getMessage();
    }

    @Override
    public UnresolvedAddress getRecipient() {
        return this.recipient;
    }

    public List<Mosaic> getMosaics() {
        return this.mosaics;
    }

    public Optional<Message> getMessage() {
        return Optional.ofNullable(this.message);
    }
}

