/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import java.util.Arrays;

public enum TransactionType {
    MOSAIC_DEFINITION(16717, 1),
    NODE_KEY_LINK(16972, 1),
    MOSAIC_SUPPLY_CHANGE(16973, 1),
    MOSAIC_SUPPLY_REVOCATION(17229, 1),
    NAMESPACE_REGISTRATION(16718, 1),
    ADDRESS_ALIAS(16974, 1),
    MOSAIC_ALIAS(17230, 1),
    TRANSFER(16724, 1),
    MULTISIG_ACCOUNT_MODIFICATION(16725, 1),
    AGGREGATE_COMPLETE(16705, 2),
    AGGREGATE_BONDED(16961, 2),
    VOTING_KEY_LINK(16707, 1),
    VRF_KEY_LINK(16963, 1),
    HASH_LOCK(16712, 1),
    ACCOUNT_ADDRESS_RESTRICTION(16720, 1),
    ACCOUNT_MOSAIC_RESTRICTION(16976, 1),
    ACCOUNT_OPERATION_RESTRICTION(17232, 1),
    SECRET_LOCK(16722, 1),
    SECRET_PROOF(16978, 1),
    ACCOUNT_METADATA(16708, 1),
    MOSAIC_METADATA(16964, 1),
    NAMESPACE_METADATA(17220, 1),
    ACCOUNT_KEY_LINK(16716, 1),
    MOSAIC_ADDRESS_RESTRICTION(16977, 1),
    MOSAIC_GLOBAL_RESTRICTION(16721, 1);

    private final int value;
    private final int currentVersion;

    private TransactionType(int value, int currentVersion) {
        this.value = value;
        this.currentVersion = currentVersion;
    }

    public static TransactionType rawValueOf(int value) {
        return Arrays.stream(TransactionType.values()).filter(e -> e.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " is not a valid value"));
    }

    public int getValue() {
        return this.value;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }
}

