/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionGroup;
import io.nem.symbol.sdk.model.transaction.TransactionInfo;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public abstract class TransactionFactory<T extends Transaction> {
    private final TransactionType type;
    private final NetworkType networkType;
    private Deadline deadline;
    private Integer version;
    private BigInteger maxFee = BigInteger.ZERO;
    private Optional<String> signature = Optional.empty();
    private Optional<PublicAccount> signer = Optional.empty();
    private Optional<TransactionInfo> transactionInfo = Optional.empty();
    private Optional<TransactionGroup> group = Optional.empty();
    private Optional<Long> size = Optional.empty();

    public TransactionFactory(TransactionType type, int version, NetworkType networkType, Deadline deadline) {
        Validate.notNull((Object)((Object)type), (String)"Type must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)networkType), (String)"NetworkType must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)deadline, (String)"deadline must not be null", (Object[])new Object[0]);
        this.type = type;
        this.networkType = networkType;
        this.version = version;
        this.deadline = deadline;
    }

    public TransactionFactory(TransactionType type, NetworkType networkType, Deadline deadline) {
        this(type, type.getCurrentVersion(), networkType, deadline);
    }

    public TransactionFactory<T> deadline(Deadline deadline) {
        Validate.notNull((Object)deadline, (String)"Deadline must not be null", (Object[])new Object[0]);
        this.deadline = deadline;
        return this;
    }

    public TransactionFactory<T> maxFee(BigInteger maxFee) {
        Validate.notNull((Object)maxFee, (String)"MaxFee must not be null", (Object[])new Object[0]);
        this.maxFee = maxFee;
        return this;
    }

    public TransactionFactory<T> calculateMaxFeeFromMultiplier(long feeMultiplier) {
        return this.maxFee(BigInteger.valueOf(this.getSize()).multiply(BigInteger.valueOf(feeMultiplier)));
    }

    public TransactionFactory<T> signature(String signature) {
        Validate.notNull((Object)signature, (String)"Signature must not be null", (Object[])new Object[0]);
        this.signature = Optional.of(signature);
        return this;
    }

    public TransactionFactory<T> signer(PublicAccount signer) {
        Validate.notNull((Object)signer, (String)"Signer must not be null", (Object[])new Object[0]);
        this.signer = Optional.of(signer);
        return this;
    }

    public TransactionFactory<T> transactionInfo(TransactionInfo transactionInfo) {
        Validate.notNull((Object)transactionInfo, (String)"TransactionInfo must not be null", (Object[])new Object[0]);
        this.transactionInfo = Optional.of(transactionInfo);
        return this;
    }

    public TransactionFactory<T> version(Integer version) {
        Validate.notNull(this.signer, (String)"Version must not be null", (Object[])new Object[0]);
        this.version = version;
        return this;
    }

    public TransactionFactory<T> size(long size) {
        this.size = Optional.of(size);
        return this;
    }

    public TransactionFactory<T> group(TransactionGroup group) {
        Validate.notNull(this.signer, (String)"Group must not be null", (Object[])new Object[0]);
        this.group = Optional.of(group);
        return this;
    }

    public TransactionType getType() {
        return this.type;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Deadline getDeadline() {
        return this.deadline;
    }

    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public Optional<String> getSignature() {
        return this.signature;
    }

    public Optional<TransactionInfo> getTransactionInfo() {
        return this.transactionInfo;
    }

    public Optional<PublicAccount> getSigner() {
        return this.signer;
    }

    protected Optional<Long> getProvidedSize() {
        return this.size;
    }

    public long getSize() {
        return this.size.orElseGet(() -> ((Transaction)this.build()).getSize());
    }

    public Optional<TransactionGroup> getGroup() {
        return this.group;
    }

    public abstract T build();
}

