/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.CryptoEngines;
import io.nem.symbol.core.crypto.DsaSigner;
import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.crypto.Signature;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.StringUtils;
import io.nem.symbol.sdk.api.BinarySerialization;
import io.nem.symbol.sdk.infrastructure.BinarySerializationImpl;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Account;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionGroup;
import io.nem.symbol.sdk.model.transaction.TransactionInfo;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import java.util.Optional;

public abstract class Transaction
implements Stored {
    private static final BinarySerialization BINARY_SERIALIZATION = BinarySerializationImpl.INSTANCE;
    private final TransactionType type;
    private final NetworkType networkType;
    private final Integer version;
    private final Deadline deadline;
    private final BigInteger maxFee;
    private final Optional<Long> size;
    private final Optional<TransactionGroup> group;
    private final Optional<String> signature;
    private final Optional<TransactionInfo> transactionInfo;
    private Optional<PublicAccount> signer;

    Transaction(TransactionFactory<?> factory) {
        this.type = factory.getType();
        this.networkType = factory.getNetworkType();
        this.version = factory.getVersion();
        this.deadline = factory.getDeadline();
        this.maxFee = factory.getMaxFee();
        this.group = factory.getGroup();
        this.signature = factory.getSignature();
        this.signer = factory.getSigner();
        this.transactionInfo = factory.getTransactionInfo();
        this.size = factory.getProvidedSize();
    }

    public TransactionType getType() {
        return this.type;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Deadline getDeadline() {
        return this.deadline;
    }

    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public Optional<String> getSignature() {
        return this.signature;
    }

    public Optional<PublicAccount> getSigner() {
        return this.signer;
    }

    public Optional<TransactionInfo> getTransactionInfo() {
        return this.transactionInfo;
    }

    public byte[] serialize() {
        return BINARY_SERIALIZATION.serialize(this);
    }

    public long getSize() {
        return this.size.orElseGet(() -> BinarySerializationImpl.INSTANCE.getSize(this));
    }

    public String createTransactionHash(String transactionPayload, byte[] generationHashBytes) {
        byte[] bytes = ConvertUtils.fromHexToBytes(transactionPayload);
        byte[] dataBytes = this.getSignBytes(bytes, generationHashBytes);
        int sizeOfSignatureAndSignerPublicKey = 96;
        byte[] signingBytes = new byte[dataBytes.length + 96];
        System.arraycopy(bytes, 8, signingBytes, 0, 96);
        System.arraycopy(dataBytes, 0, signingBytes, 96, dataBytes.length);
        byte[] result = Hashes.sha3_256(new byte[][]{signingBytes});
        return ConvertUtils.toHex(result);
    }

    public byte[] getSignBytes(byte[] payloadBytes, byte[] generationHashBytes) {
        int headerSize = 108;
        byte[] signingBytes = new byte[payloadBytes.length + generationHashBytes.length - 108];
        System.arraycopy(generationHashBytes, 0, signingBytes, 0, generationHashBytes.length);
        System.arraycopy(payloadBytes, 108, signingBytes, generationHashBytes.length, payloadBytes.length - 108);
        return signingBytes;
    }

    public SignedTransaction signWith(Account account, String generationHash) {
        DsaSigner theSigner = CryptoEngines.defaultEngine().createDsaSigner(account.getKeyPair());
        byte[] bytes = this.serialize();
        byte[] generationHashBytes = ConvertUtils.getBytes(generationHash);
        byte[] signingBytes = this.getSignBytes(bytes, generationHashBytes);
        Signature theSignature = theSigner.sign(signingBytes);
        byte[] payload = new byte[bytes.length];
        System.arraycopy(bytes, 0, payload, 0, 8);
        System.arraycopy(theSignature.getBytes(), 0, payload, 8, theSignature.getBytes().length);
        System.arraycopy(account.getKeyPair().getPublicKey().getBytes(), 0, payload, 72, account.getKeyPair().getPublicKey().getBytes().length);
        System.arraycopy(bytes, 104, payload, 104, bytes.length - 104);
        String hash = this.createTransactionHash(ConvertUtils.toHex(payload), generationHashBytes);
        return new SignedTransaction(account.getPublicAccount(), ConvertUtils.toHex(payload), hash, this.type);
    }

    public Transaction toAggregate(PublicAccount signer) {
        this.signer = Optional.of(signer);
        return this;
    }

    public boolean isUnconfirmed() {
        return this.getGroup().filter(g -> g == TransactionGroup.UNCONFIRMED).isPresent();
    }

    public boolean isPartial() {
        return this.getGroup().filter(g -> g == TransactionGroup.PARTIAL).isPresent();
    }

    public boolean hasMissingSignatures() {
        return this.getTransactionInfo().filter(info -> info.getHeight().equals(BigInteger.valueOf(0L)) && !StringUtils.equalsIgnoreCase(info.getHash(), info.getMerkleComponentHash())).isPresent();
    }

    public boolean isUnannounced() {
        return !this.getGroup().isPresent();
    }

    public boolean isConfirmed() {
        return this.getGroup().filter(g -> g == TransactionGroup.CONFIRMED).isPresent();
    }

    public Optional<TransactionGroup> getGroup() {
        return this.group;
    }

    public boolean isTransactionFullyLoaded() {
        return true;
    }

    @Override
    public Optional<String> getRecordId() {
        return this.getTransactionInfo().flatMap(TransactionInfo::getId);
    }
}

