/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.LockHashAlgorithm;
import io.nem.symbol.sdk.model.transaction.SecretProofTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import org.apache.commons.lang3.Validate;

public class SecretProofTransactionFactory
extends TransactionFactory<SecretProofTransaction> {
    private final LockHashAlgorithm hashType;
    private final String secret;
    private final String proof;
    private final UnresolvedAddress recipient;

    private SecretProofTransactionFactory(NetworkType networkType, Deadline deadline, LockHashAlgorithm hashType, UnresolvedAddress recipient, String secret, String proof) {
        super(TransactionType.SECRET_PROOF, networkType, deadline);
        Validate.notNull((Object)secret, (String)"Secret must not be null.", (Object[])new Object[0]);
        Validate.notNull((Object)proof, (String)"Proof must not be null.", (Object[])new Object[0]);
        Validate.notNull((Object)recipient, (String)"Recipient must not be null.", (Object[])new Object[0]);
        if (!LockHashAlgorithm.validator(hashType, secret)) {
            throw new IllegalArgumentException("HashType  " + hashType + " and Secret have incompatible length or not hexadecimal string");
        }
        this.hashType = hashType;
        this.secret = secret;
        this.proof = proof;
        this.recipient = recipient;
    }

    public static SecretProofTransactionFactory create(NetworkType networkType, Deadline deadline, LockHashAlgorithm hashType, UnresolvedAddress recipient, String secret, String proof) {
        return new SecretProofTransactionFactory(networkType, deadline, hashType, recipient, secret, proof);
    }

    public LockHashAlgorithm getHashType() {
        return this.hashType;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getProof() {
        return this.proof;
    }

    public UnresolvedAddress getRecipient() {
        return this.recipient;
    }

    @Override
    public SecretProofTransaction build() {
        return new SecretProofTransaction(this);
    }
}

