/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.LockHashAlgorithm;
import io.nem.symbol.sdk.model.transaction.SecretLockTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class SecretLockTransactionFactory
extends TransactionFactory<SecretLockTransaction> {
    private final Mosaic mosaic;
    private final BigInteger duration;
    private final LockHashAlgorithm hashAlgorithm;
    private final String secret;
    private final UnresolvedAddress recipient;

    private SecretLockTransactionFactory(NetworkType networkType, Deadline deadline, Mosaic mosaic, BigInteger duration, LockHashAlgorithm hashAlgorithm, String secret, UnresolvedAddress recipient) {
        super(TransactionType.SECRET_LOCK, networkType, deadline);
        Validate.notNull((Object)mosaic, (String)"Mosaic must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)duration, (String)"Duration must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)secret, (String)"Secret must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)recipient, (String)"Recipient must not be null", (Object[])new Object[0]);
        if (!LockHashAlgorithm.validator(hashAlgorithm, secret)) {
            throw new IllegalArgumentException("HashType and Secret have incompatible length or not hexadecimal string");
        }
        ConvertUtils.validateNotNegative(duration);
        this.mosaic = mosaic;
        this.duration = duration;
        this.hashAlgorithm = hashAlgorithm;
        this.secret = secret;
        this.recipient = recipient;
    }

    public static SecretLockTransactionFactory create(NetworkType networkType, Deadline deadline, Mosaic mosaic, BigInteger duration, LockHashAlgorithm hashAlgorithm, String secret, UnresolvedAddress recipient) {
        return new SecretLockTransactionFactory(networkType, deadline, mosaic, duration, hashAlgorithm, secret, recipient);
    }

    public Mosaic getMosaic() {
        return this.mosaic;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public LockHashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getSecret() {
        return this.secret;
    }

    public UnresolvedAddress getRecipient() {
        return this.recipient;
    }

    @Override
    public SecretLockTransaction build() {
        return new SecretLockTransaction(this);
    }
}

