/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.LockHashAlgorithmDto;
import io.nem.symbol.catapult.builders.LockStatusDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.SecretLockInfoBuilder;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.transaction.LockHashAlgorithm;
import io.nem.symbol.sdk.model.transaction.LockStatus;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class SecretLockInfo
implements Stored {
    private final String recordId;
    private final int version;
    private final Address ownerAddress;
    private final MosaicId mosaicId;
    private final BigInteger amount;
    private final BigInteger endHeight;
    private final LockStatus status;
    private final LockHashAlgorithm hashAlgorithm;
    private final String secret;
    private final Address recipientAddress;
    private final String compositeHash;

    public SecretLockInfo(String recordId, int version, Address ownerAddress, MosaicId mosaicId, BigInteger amount, BigInteger endHeight, LockStatus status, LockHashAlgorithm hashAlgorithm, String secret, Address recipientAddress, String compositeHash) {
        this.version = version;
        Validate.notNull((Object)ownerAddress, (String)"ownerAddress is required", (Object[])new Object[0]);
        Validate.notNull((Object)mosaicId, (String)"mosaicId is required", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"amount is required", (Object[])new Object[0]);
        Validate.notNull((Object)endHeight, (String)"endHeight is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)status), (String)"status is required", (Object[])new Object[0]);
        Validate.notNull((Object)secret, (String)"secret is required", (Object[])new Object[0]);
        Validate.notNull((Object)recipientAddress, (String)"recipientAddress is required", (Object[])new Object[0]);
        this.recordId = recordId;
        this.ownerAddress = ownerAddress;
        this.mosaicId = mosaicId;
        this.amount = amount;
        this.endHeight = endHeight;
        this.status = status;
        this.hashAlgorithm = hashAlgorithm;
        this.secret = secret;
        this.recipientAddress = recipientAddress;
        this.compositeHash = compositeHash;
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public BigInteger getEndHeight() {
        return this.endHeight;
    }

    public LockStatus getStatus() {
        return this.status;
    }

    public LockHashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getSecret() {
        return this.secret;
    }

    public Address getRecipientAddress() {
        return this.recipientAddress;
    }

    public String getCompositeHash() {
        return this.compositeHash;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] serialize() {
        short version = (short)this.getVersion();
        AddressDto ownerAddress = SerializationUtils.toAddressDto(this.getOwnerAddress());
        MosaicBuilder mosaic = MosaicBuilder.create((MosaicIdDto)SerializationUtils.toMosaicIdDto(this.getMosaicId()), (AmountDto)SerializationUtils.toAmount(this.getAmount()));
        HeightDto endHeight = new HeightDto(this.getEndHeight().longValue());
        LockStatusDto status = LockStatusDto.rawValueOf((byte)this.getStatus().getValue());
        Hash256Dto secret = SerializationUtils.toHash256Dto(this.getSecret());
        AddressDto recipient = SerializationUtils.toAddressDto(this.getRecipientAddress());
        LockHashAlgorithmDto hashAlgorithm = LockHashAlgorithmDto.rawValueOf((byte)((byte)this.hashAlgorithm.getValue()));
        return SecretLockInfoBuilder.create((short)version, (AddressDto)ownerAddress, (MosaicBuilder)mosaic, (HeightDto)endHeight, (LockStatusDto)status, (LockHashAlgorithmDto)hashAlgorithm, (Hash256Dto)secret, (AddressDto)recipient).serialize();
    }
}

