/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.NodeKeyLinkTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import org.apache.commons.lang3.Validate;

public class NodeKeyLinkTransactionFactory
extends TransactionFactory<NodeKeyLinkTransaction> {
    private final PublicKey linkedPublicKey;
    private final LinkAction linkAction;

    private NodeKeyLinkTransactionFactory(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, LinkAction linkAction) {
        super(TransactionType.NODE_KEY_LINK, networkType, deadline);
        Validate.notNull((Object)linkedPublicKey, (String)"linkedPublicKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)linkAction), (String)"linkAction must not be null", (Object[])new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.linkAction = linkAction;
    }

    public static NodeKeyLinkTransactionFactory create(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, LinkAction linkAction) {
        return new NodeKeyLinkTransactionFactory(networkType, deadline, linkedPublicKey, linkAction);
    }

    @Override
    public NodeKeyLinkTransaction build() {
        return new NodeKeyLinkTransaction(this);
    }

    public PublicKey getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkAction getLinkAction() {
        return this.linkAction;
    }
}

