/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.NamespaceRegistrationTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class NamespaceRegistrationTransactionFactory
extends TransactionFactory<NamespaceRegistrationTransaction> {
    private final String namespaceName;
    private final NamespaceId namespaceId;
    private final Optional<BigInteger> duration;
    private final Optional<NamespaceId> parentId;
    private final NamespaceRegistrationType namespaceRegistrationType;

    private NamespaceRegistrationTransactionFactory(NetworkType networkType, Deadline deadline, String namespaceName, NamespaceId namespaceId, NamespaceRegistrationType namespaceRegistrationType, Optional<BigInteger> duration, Optional<NamespaceId> parentId) {
        super(TransactionType.NAMESPACE_REGISTRATION, networkType, deadline);
        Validate.notNull((Object)namespaceName, (String)"NamespaceName must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)namespaceRegistrationType), (String)"NamespaceType must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)namespaceId, (String)"NamespaceId must not be null", (Object[])new Object[0]);
        if (namespaceRegistrationType == NamespaceRegistrationType.ROOT_NAMESPACE) {
            Validate.isTrue((boolean)duration.isPresent(), (String)"Duration must be provided", (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)parentId.isPresent(), (String)"ParentId must be provided", (Object[])new Object[0]);
        }
        this.namespaceName = namespaceName;
        this.namespaceRegistrationType = namespaceRegistrationType;
        this.namespaceId = namespaceId;
        this.duration = duration;
        this.parentId = parentId;
    }

    public static NamespaceRegistrationTransactionFactory create(NetworkType networkType, Deadline deadline, String namespaceName, NamespaceId namespaceId, NamespaceRegistrationType namespaceRegistrationType, Optional<BigInteger> duration, Optional<NamespaceId> parentId) {
        return new NamespaceRegistrationTransactionFactory(networkType, deadline, namespaceName, namespaceId, namespaceRegistrationType, duration, parentId);
    }

    public static NamespaceRegistrationTransactionFactory createRootNamespace(NetworkType networkType, Deadline deadline, String namespaceName, BigInteger duration) {
        NamespaceId namespaceId = NamespaceId.createFromName(namespaceName);
        return NamespaceRegistrationTransactionFactory.create(networkType, deadline, namespaceName, namespaceId, NamespaceRegistrationType.ROOT_NAMESPACE, Optional.of(duration), Optional.empty());
    }

    public static NamespaceRegistrationTransactionFactory createSubNamespace(NetworkType networkType, Deadline deadline, String namespaceName, NamespaceId parentId) {
        NamespaceId namespaceId = NamespaceId.createFromNameAndParentId(namespaceName, parentId.getId());
        return NamespaceRegistrationTransactionFactory.create(networkType, deadline, namespaceName, namespaceId, NamespaceRegistrationType.SUB_NAMESPACE, Optional.empty(), Optional.of(parentId));
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceId getNamespaceId() {
        return this.namespaceId;
    }

    public Optional<BigInteger> getDuration() {
        return this.duration;
    }

    public Optional<NamespaceId> getParentId() {
        return this.parentId;
    }

    public NamespaceRegistrationType getNamespaceRegistrationType() {
        return this.namespaceRegistrationType;
    }

    @Override
    public NamespaceRegistrationTransaction build() {
        return new NamespaceRegistrationTransaction(this);
    }
}

