/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.NamespaceMetadataTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class NamespaceMetadataTransactionFactory
extends MetadataTransactionFactory<NamespaceMetadataTransaction> {
    private final NamespaceId targetNamespaceId;

    private NamespaceMetadataTransactionFactory(NetworkType networkType, Deadline deadline, UnresolvedAddress targetAddress, NamespaceId targetNamespaceId, BigInteger scopedMetadataKey, byte[] value) {
        super(TransactionType.NAMESPACE_METADATA, networkType, deadline, targetAddress, scopedMetadataKey, value);
        Validate.notNull((Object)targetNamespaceId, (String)"TargetNamespaceId must not be null", (Object[])new Object[0]);
        this.targetNamespaceId = targetNamespaceId;
    }

    public static NamespaceMetadataTransactionFactory create(NetworkType networkType, Deadline deadline, UnresolvedAddress targetAddress, NamespaceId targetNamespaceId, BigInteger scopedMetadataKey, byte[] value) {
        return new NamespaceMetadataTransactionFactory(networkType, deadline, targetAddress, targetNamespaceId, scopedMetadataKey, value);
    }

    public NamespaceId getTargetNamespaceId() {
        return this.targetNamespaceId;
    }

    @Override
    public NamespaceMetadataTransaction build() {
        return new NamespaceMetadataTransaction(this);
    }
}

